/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.syntax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.text.StringUtils;

public class SyntaxType
implements Comparable<SyntaxType> {
    private static final Map<String, SyntaxType> KNOWN_SYNTAX_TYPES = new HashMap<String, SyntaxType>();
    public static final SyntaxType XWIKI = SyntaxType.register("xwiki", "XWiki");
    public static final SyntaxType CONFLUENCE = SyntaxType.register("confluence", "Confluence");
    public static final SyntaxType CONFLUENCEXHTML = SyntaxType.register("confluence", Arrays.asList("xhtml"), "Confluence (XHTML)");
    public static final SyntaxType MEDIAWIKI = SyntaxType.register("mediawiki", "MediaWiki");
    public static final SyntaxType DOKUWIKI = new SyntaxType("dokuwiki", "DokuWiki");
    public static final SyntaxType CREOLE = SyntaxType.register("creole", "Creole");
    public static final SyntaxType JSPWIKI = SyntaxType.register("jspwiki", "JSPWiki");
    public static final SyntaxType TWIKI = SyntaxType.register("twiki", "TWiki");
    public static final SyntaxType XHTML = SyntaxType.register("xhtml", "XHTML");
    public static final SyntaxType ANNOTATED_XHTML = SyntaxType.register("annotatedxhtml", "Annotated XHTML");
    public static final SyntaxType ANNOTATED_HTML = SyntaxType.register("annotatedhtml", "Annotated HTML");
    public static final SyntaxType HTML = SyntaxType.register("html", "HTML");
    public static final SyntaxType PLAIN = SyntaxType.register("plain", "Plain");
    public static final SyntaxType EVENT = SyntaxType.register("event", "Event");
    public static final SyntaxType TEX = SyntaxType.register("tex", "TeX");
    public static final SyntaxType DOCBOOK = SyntaxType.register("docbook", "DocBook");
    public static final SyntaxType XDOMXML = SyntaxType.register("xdom", Arrays.asList("xml"), "XDOM (XML)");
    public static final SyntaxType MARKDOWN = SyntaxType.register("markdown", "Markdown");
    public static final SyntaxType APT = SyntaxType.register("apt", "APT");
    private String name;
    private String id;
    private List<String> variants;
    private volatile transient String idStringCache;

    public SyntaxType(String id, String name) {
        this(id, Collections.emptyList(), name);
    }

    public SyntaxType(String id, List<String> variants, String name) {
        this.id = id;
        this.variants = variants == null || variants.isEmpty() ? Collections.emptyList() : new ArrayList<String>(variants);
        this.name = name;
    }

    private static SyntaxType register(String id, String name) {
        return SyntaxType.register(id, Collections.emptyList(), name);
    }

    private static SyntaxType register(String id, List<String> variants, String name) {
        SyntaxType syntaxType = new SyntaxType(id, variants, name);
        KNOWN_SYNTAX_TYPES.put(SyntaxType.computeIdString(id, variants), syntaxType);
        return syntaxType;
    }

    @Deprecated
    public static Map<String, SyntaxType> getSyntaxTypes() {
        return KNOWN_SYNTAX_TYPES;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getVariants() {
        return this.variants == null ? Collections.emptyList() : this.variants;
    }

    public String getName() {
        return this.name;
    }

    public String toIdString() {
        if (this.idStringCache == null) {
            this.idStringCache = SyntaxType.computeIdString(this.getId(), this.getVariants());
        }
        return this.idStringCache;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 7).append((Object)this.getId()).append(this.getVariants()).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SyntaxType)) {
            return false;
        }
        SyntaxType rhs = (SyntaxType)object;
        return new EqualsBuilder().append((Object)this.getId(), (Object)rhs.getId()).append(this.getVariants(), rhs.getVariants()).isEquals();
    }

    @Override
    public int compareTo(SyntaxType syntaxType) {
        return new CompareToBuilder().append((Object)this.getName(), (Object)syntaxType.getName()).toComparison();
    }

    public static SyntaxType valueOf(String syntaxTypesString) throws ParseException {
        if (syntaxTypesString == null) {
            throw new ParseException("The passed Syntax type cannot be NULL");
        }
        String[] tokens = StringUtils.split((String)syntaxTypesString, (char)'+');
        String id = tokens[0];
        ArrayList<String> variants = new ArrayList<String>();
        for (int i = 1; i < tokens.length; ++i) {
            variants.add(tokens[i]);
        }
        String idString = SyntaxType.computeIdString(id, variants);
        SyntaxType syntaxType = SyntaxType.getSyntaxTypes().get(idString);
        if (syntaxType == null) {
            syntaxType = new SyntaxType(id, variants, idString);
        }
        return syntaxType;
    }

    private static String computeIdString(String id, List<String> variants) {
        StringBuilder idString = new StringBuilder();
        idString.append(id);
        for (String variant : variants) {
            idString.append('+').append(variant);
        }
        return idString.toString();
    }
}

