/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.xml.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.diff.xml.StringSplitter;
import org.xwiki.diff.xml.XMLDiffConfiguration;
import org.xwiki.diff.xml.XMLDiffFilter;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultXMLDiffConfiguration
implements XMLDiffConfiguration,
Initializable {
    @Inject
    private StringSplitter defaultSplitter;
    @Inject
    @Named(value="character")
    private StringSplitter characterSplitter;
    private final Map<Short, StringSplitter> splitterByNodeType = new HashMap<Short, StringSplitter>();
    private double similarityThreshold = 0.6;
    private final List<XMLDiffFilter> filters = new ArrayList<XMLDiffFilter>();

    public void initialize() throws InitializationException {
        this.setSplitterForNodeType((short)3, this.characterSplitter);
    }

    @Override
    public StringSplitter getSplitterForNodeType(short nodeType) {
        return this.splitterByNodeType.getOrDefault(nodeType, this.defaultSplitter);
    }

    public void setSplitterForNodeType(short nodeType, StringSplitter splitter) {
        this.splitterByNodeType.put(nodeType, splitter);
    }

    @Override
    public double getSimilarityThreshold() {
        return this.similarityThreshold;
    }

    public void setSimilarityThreshold(double similarityThreshold) {
        this.similarityThreshold = similarityThreshold;
    }

    @Override
    public List<XMLDiffFilter> getFilters() {
        return this.filters;
    }
}

