/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.xml.internal;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.diff.DiffException;
import org.xwiki.diff.xml.XMLDiffConfiguration;
import org.xwiki.diff.xml.XMLDiffFilter;
import org.xwiki.diff.xml.XMLDiffManager;
import org.xwiki.diff.xml.XMLDiffMarker;
import org.xwiki.xml.XMLUtils;
import org.xwiki.xml.html.HTMLCleaner;
import org.xwiki.xml.html.HTMLCleanerConfiguration;
import org.xwiki.xml.html.HTMLUtils;

@Component
@Singleton
@Named(value="html/unified")
public class UnifiedHTMLDiffManager
implements XMLDiffManager,
Initializable {
    @Inject
    private Logger logger;
    @Inject
    private HTMLCleaner htmlCleaner;
    @Inject
    @Named(value="html")
    private XMLDiffMarker htmlDiffMarker;
    private DOMImplementationLS lsImpl;
    private Map<String, String> htmlCleanerParametersMap;

    public void initialize() throws InitializationException {
        try {
            this.lsImpl = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS 3.0"));
        }
        catch (Exception exception) {
            throw new InitializationException("Failed to initialize DOM Level 3 Load and Save APIs.", (Throwable)exception);
        }
        this.htmlCleanerParametersMap = new HashMap<String, String>();
        this.htmlCleanerParametersMap.put("useCharacterReferences", Boolean.toString(true));
    }

    @Override
    public String diff(String previousHTML, String nextHTML, XMLDiffConfiguration config) throws DiffException {
        Document nextDocument;
        List<XMLDiffFilter> filters = config.getFilters();
        Document previousDocument = this.filterBeforeDiff(this.parseHTML(previousHTML), filters);
        if (!this.htmlDiffMarker.markDiff(previousDocument, nextDocument = this.filterBeforeDiff(this.parseHTML(nextHTML), filters), config)) {
            return "";
        }
        return this.unwrap(HTMLUtils.toString((Document)this.filterAfterDiff(previousDocument, filters), (boolean)false, (boolean)false).trim());
    }

    private Document parseHTML(String html) {
        return this.parseXML(this.cleanHTML(html));
    }

    private String cleanHTML(String html) {
        HTMLCleanerConfiguration config = this.htmlCleaner.getDefaultConfiguration();
        config.setParameters(this.htmlCleanerParametersMap);
        Document htmlDoc = this.htmlCleaner.clean((Reader)new StringReader(this.wrap(html)), config);
        return HTMLUtils.toString((Document)htmlDoc);
    }

    private Document parseXML(String xml) {
        LSInput input = this.lsImpl.createLSInput();
        input.setStringData(xml);
        return XMLUtils.parse((LSInput)input);
    }

    private String wrap(String fragment) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html><html xmlns=\"http://www.w3.org/1999/xhtml\"><head></head><body>" + fragment + "</body></html>";
    }

    private String unwrap(String html) {
        int start = html.indexOf("<body>") + 6;
        int end = html.indexOf("</body>");
        return html.substring(start, end);
    }

    private Document filterBeforeDiff(Document document, List<XMLDiffFilter> filters) {
        for (XMLDiffFilter filter : filters) {
            try {
                filter.before(document);
            }
            catch (Exception e) {
                this.logger.warn("Failed to apply filter before diff.", (Throwable)e);
            }
        }
        return document;
    }

    private Document filterAfterDiff(Document document, List<XMLDiffFilter> filters) {
        for (XMLDiffFilter filter : filters) {
            try {
                filter.after(document);
            }
            catch (Exception e) {
                this.logger.warn("Failed to apply filter after diff.", (Throwable)e);
            }
        }
        return document;
    }
}

