/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.xml.internal;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xwiki.diff.Chunk;
import org.xwiki.diff.Delta;
import org.xwiki.diff.DiffException;
import org.xwiki.diff.Patch;
import org.xwiki.diff.PatchException;
import org.xwiki.diff.xml.XMLDiff;
import org.xwiki.diff.xml.XMLDiffConfiguration;
import org.xwiki.diff.xml.XMLDiffMarker;
import org.xwiki.diff.xml.internal.XMLDiffUtils;

public abstract class AbstractXMLDiffMarker
implements XMLDiffMarker {
    private static final String FUTURE_PARENT = "xwiki-xml-diff-marker-future-parent";
    private static final String TEXT_WRAPPER = "xwiki-xml-diff-marker-text-wrapper";
    @Inject
    private XMLDiff xmlDiff;

    @Override
    public boolean markDiff(Node left, Node right) throws DiffException {
        left.normalize();
        right.normalize();
        Map<Node, Patch<?>> patches = this.xmlDiff.diff(left, right, new XMLDiffConfiguration());
        patches = this.filterPatches(patches);
        patches = this.markDiffBlocks(patches);
        this.applyPatches(patches);
        this.cleanUp(left);
        return !patches.isEmpty();
    }

    protected Map<Node, Patch<?>> filterPatches(Map<Node, Patch<?>> patches) {
        LinkedHashMap acceptedPatches = new LinkedHashMap();
        for (Map.Entry<Node, Patch<?>> entry : patches.entrySet()) {
            if (!this.acceptPatch(entry.getKey(), entry.getValue())) continue;
            acceptedPatches.put(entry.getKey(), entry.getValue());
        }
        return acceptedPatches;
    }

    protected boolean acceptPatch(Node node, Patch<?> patch) {
        if (node != null && !patch.isEmpty()) {
            if (node.getNodeType() == 3) {
                return this.acceptPatch((Text)node, patch);
            }
            if (node.getNodeType() == 1) {
                return this.acceptPatch((Element)node, patch);
            }
            if (node.getNodeType() == 2) {
                return this.acceptPatch((Attr)node, patch);
            }
        }
        return false;
    }

    protected boolean acceptPatch(Text text, Patch<Character> patch) {
        Node parent = text.getParentNode();
        return parent != null && parent.getNodeType() == 1 && this.acceptChangesFor((Element)parent);
    }

    protected boolean acceptPatch(Element element, Patch<Node> patch) {
        if (!this.acceptChangesFor(element)) {
            return false;
        }
        List attributesDeltas = patch.stream().filter(delta -> delta.getPrevious().getIndex() < 0).collect(Collectors.toList());
        if (attributesDeltas.size() == patch.size()) {
            for (Delta delta2 : attributesDeltas) {
                boolean acceptAttributes = delta2.getPrevious().getElements().stream().anyMatch(node -> this.acceptChangesFor((Attr)node));
                acceptAttributes = acceptAttributes || delta2.getNext().getElements().stream().anyMatch(node -> this.acceptChangesFor((Attr)node));
                if (!acceptAttributes) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean acceptPatch(Attr attribute, Patch<Character> patch) {
        return this.acceptChangesFor(attribute);
    }

    protected boolean acceptChangesFor(Element element) {
        return true;
    }

    protected boolean acceptChangesFor(Attr attribute) {
        return true;
    }

    protected Map<Node, Patch<?>> markDiffBlocks(Map<Node, Patch<?>> patches) {
        LinkedHashMap acceptedPatches = new LinkedHashMap();
        HashSet<Node> diffBlocks = new HashSet<Node>();
        for (Map.Entry<Node, Patch<?>> entry : patches.entrySet()) {
            Set<Node> patchDiffBlocks = this.getDiffBlocks(entry.getKey(), entry.getValue());
            if (patchDiffBlocks.isEmpty() || patchDiffBlocks.contains(null)) continue;
            acceptedPatches.put(entry.getKey(), entry.getValue());
            diffBlocks.addAll(patchDiffBlocks);
        }
        diffBlocks.stream().forEach(node -> this.markDiffBlock((Element)node));
        Set nestedDiffBlocks = diffBlocks.stream().filter(this::hasDiffBlockParent).collect(Collectors.toSet());
        nestedDiffBlocks.stream().forEach(node -> this.unmarkDiffBlock((Element)node));
        diffBlocks.removeAll(nestedDiffBlocks);
        return acceptedPatches;
    }

    protected Set<Node> getDiffBlocks(Node node, Patch<?> patch) {
        HashSet<Node> diffBlocks = new HashSet<Node>();
        if (node.getNodeValue() != null) {
            diffBlocks.add(this.getDiffBlock(node));
        } else {
            Patch<?> childrenPatch = patch;
            List childrenDeltas = childrenPatch.stream().filter(delta -> delta.getPrevious().getIndex() >= 0).collect(Collectors.toList());
            if (childrenDeltas.size() < patch.size()) {
                diffBlocks.add(this.getDiffBlock(node));
            } else {
                for (Delta delta2 : childrenPatch) {
                    diffBlocks.addAll(this.getDiffBlocks(node, delta2.getPrevious().getElements()));
                    diffBlocks.addAll(this.getDiffBlocks(node, delta2.getNext().getElements()));
                }
            }
        }
        return diffBlocks;
    }

    private Set<Node> getDiffBlocks(Node parent, List<Node> children) {
        return children.stream().map(child -> this.getDiffBlock(parent, (Node)child)).collect(Collectors.toSet());
    }

    private Node getDiffBlock(Node parent, Node child) {
        if (child.getParentNode() != parent) {
            child.setUserData(FUTURE_PARENT, parent, null);
        }
        return this.getDiffBlock(child);
    }

    protected Node getDiffBlock(Node node) {
        Node diffBlock = node;
        if (node.getNodeType() == 2) {
            diffBlock = ((Attr)node).getOwnerElement();
        }
        while (!(diffBlock == null || diffBlock.getNodeType() == 1 && this.acceptAsDiffBlock((Element)diffBlock))) {
            diffBlock = this.getParentNode(diffBlock);
        }
        return diffBlock;
    }

    protected abstract boolean acceptAsDiffBlock(Element var1);

    protected abstract void markDiffBlock(Element var1);

    protected abstract void unmarkDiffBlock(Element var1);

    protected abstract boolean isMarkedAsDiffBlock(Element var1);

    private boolean hasDiffBlockParent(Node node) {
        Node parent = this.getParentNode(node);
        while (!(parent == null || parent.getNodeType() == 1 && this.isMarkedAsDiffBlock((Element)parent))) {
            parent = this.getParentNode(parent);
        }
        return parent != null && parent.getNodeType() == 1;
    }

    private Node getParentNode(Node node) {
        if (node.getNodeType() == 2) {
            return ((Attr)node).getOwnerElement();
        }
        Node futureParent = (Node)node.getUserData(FUTURE_PARENT);
        return futureParent != null ? futureParent : node.getParentNode();
    }

    protected void applyPatches(Map<Node, Patch<?>> patches) throws PatchException {
        for (Map.Entry<Node, Patch<?>> entry : patches.entrySet()) {
            this.applyPatch(entry.getKey(), entry.getValue());
        }
    }

    protected void applyPatch(Node node, Patch<?> patch) throws PatchException {
        if (node.getNodeValue() != null) {
            if (node.getNodeType() == 3) {
                this.applyPatch((Text)node, patch);
            } else if (node.getNodeType() == 2) {
                this.applyPatch((Attr)node, patch);
            }
        } else if (node.getNodeType() == 1) {
            this.applyPatch((Element)node, patch);
        }
    }

    protected void applyPatch(Text textLeft, Patch<Character> patch) throws PatchException {
        Text textRight = (Text)this.getOrCreateRightNode(textLeft);
        textRight.setNodeValue(this.applyPatch(textLeft.getNodeValue(), patch));
        Element parentLeft = (Element)textLeft.getParentNode();
        if (this.supportsInlineMarkerElements(parentLeft)) {
            this.markTextValueChange(textLeft, patch, true);
            this.markTextValueChange(textRight, patch, false);
        } else {
            this.markElementModified(parentLeft, true);
            this.markElementModified((Element)textRight.getParentNode(), false);
        }
    }

    protected boolean supportsInlineMarkerElements(Element parent) {
        return true;
    }

    protected void markTextValueChange(Node text, Patch<Character> patch, boolean left) {
        Document document = text.getOwnerDocument();
        Element wrapper = document.createElement(this.getInlineMarkerElementName());
        wrapper.setAttribute(TEXT_WRAPPER, "true");
        String textValue = text.getNodeValue();
        int lastIndex = 0;
        for (Delta delta : patch) {
            Chunk chunk = left ? delta.getPrevious() : delta.getNext();
            if (chunk.size() <= 0) continue;
            wrapper.appendChild(document.createTextNode(textValue.substring(lastIndex, chunk.getIndex())));
            Element marker = document.createElement(this.getInlineMarkerElementName());
            marker.appendChild(document.createTextNode(this.toString(chunk.getElements())));
            wrapper.appendChild(marker);
            this.markElementModified(marker, left);
            lastIndex = chunk.getLastIndex() + 1;
        }
        wrapper.appendChild(document.createTextNode(textValue.substring(lastIndex)));
        text.getParentNode().replaceChild(wrapper, text);
    }

    protected abstract String getInlineMarkerElementName();

    protected void applyPatch(Attr attributeLeft, Patch<Character> patch) throws PatchException {
        Attr attributeRight = (Attr)this.getOrCreateRightNode(attributeLeft);
        attributeRight.setValue(this.applyPatch(attributeLeft.getValue(), patch));
        this.markElementModified(attributeLeft.getOwnerElement(), true);
        this.markElementModified(attributeRight.getOwnerElement(), false);
    }

    private String applyPatch(String string, Patch<Character> patch) throws PatchException {
        List chars = string.chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toList());
        return this.toString(patch.apply(chars));
    }

    private String toString(List<Character> characters) {
        StringBuilder stringBuilder = new StringBuilder();
        characters.forEach(stringBuilder::append);
        return stringBuilder.toString();
    }

    protected void applyPatch(Element parent, Patch<Node> patch) {
        List<Delta<Node>> childrenDeltas;
        List<Delta<Node>> attributesDeltas = patch.stream().filter(delta -> delta.getPrevious().getIndex() < 0).collect(Collectors.toList());
        if (!attributesDeltas.isEmpty()) {
            this.applyAttributesPatch(parent, attributesDeltas);
        }
        if (!(childrenDeltas = patch.stream().filter(delta -> delta.getPrevious().getIndex() >= 0).collect(Collectors.toList())).isEmpty()) {
            this.applyChildrenPatch(parent, childrenDeltas);
        }
    }

    protected void applyAttributesPatch(Element elementLeft, List<Delta<Node>> deltas) {
        Element elementRight = (Element)this.getOrCreateRightNode(elementLeft);
        for (Delta<Node> delta : deltas) {
            for (Node attr : delta.getPrevious().getElements()) {
                elementRight.removeAttribute(attr.getNodeName());
            }
            for (Node attr : delta.getNext().getElements()) {
                elementRight.setAttribute(attr.getNodeName(), attr.getNodeValue());
            }
        }
        this.markElementModified(elementLeft, true);
        this.markElementModified(elementRight, false);
    }

    protected void applyChildrenPatch(Element parentLeft, List<Delta<Node>> deltas) {
        Element parentRight = this.isInsideDiffBlock(parentLeft) ? (Element)this.getOrCreateRightNode(parentLeft) : parentLeft;
        ListIterator<Delta<Node>> deltaIterator = deltas.listIterator(deltas.size());
        while (deltaIterator.hasPrevious()) {
            Delta<Node> delta = deltaIterator.previous();
            for (Node node : delta.getPrevious().getElements()) {
                this.markNodeModified(node, true);
                if (parentRight == parentLeft) continue;
                parentRight.removeChild(parentRight.getChildNodes().item(delta.getPrevious().getIndex()));
            }
            int insertIndex = delta.getPrevious().getIndex();
            if (parentRight == parentLeft) {
                insertIndex += delta.getPrevious().size();
            }
            Node referenceChild = null;
            if (insertIndex < parentRight.getChildNodes().getLength()) {
                referenceChild = parentRight.getChildNodes().item(insertIndex);
            }
            for (Node node : delta.getNext().getElements()) {
                Node nodeToInsert = node.cloneNode(true);
                parentRight.getOwnerDocument().adoptNode(nodeToInsert);
                parentRight.insertBefore(nodeToInsert, referenceChild);
                this.markNodeModified(nodeToInsert, false);
            }
        }
    }

    private boolean isInsideDiffBlock(Element element) {
        return this.isMarkedAsDiffBlock(element) || this.hasDiffBlockParent(element);
    }

    protected void markNodeModified(Node node, boolean deleted) {
        Element element = null;
        if (node.getNodeType() == 1) {
            element = (Element)node;
        } else if (node.getNodeType() == 3) {
            Element parent = (Element)node.getParentNode();
            if (node.getPreviousSibling() == null && node.getNextSibling() == null || !this.supportsInlineMarkerElements(parent)) {
                element = parent;
            } else {
                element = node.getOwnerDocument().createElement(this.getInlineMarkerElementName());
                parent.insertBefore(element, node);
                element.appendChild(node);
            }
        }
        if (element != null) {
            this.markElementModified(element, deleted);
        }
    }

    protected abstract void markElementModified(Element var1, boolean var2);

    protected abstract Node getOrCreateRightNode(Node var1);

    protected void cleanUp(Node node) {
        this.removeTextWrappers(node);
    }

    private void removeTextWrappers(Node node) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String expression = "//" + this.getInlineMarkerElementName() + "[@" + TEXT_WRAPPER + "]";
        try {
            XMLDiffUtils.asList((NodeList)xpath.compile(expression).evaluate(node, XPathConstants.NODESET)).stream().forEach(this::replaceWithChildren);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
    }

    private void replaceWithChildren(Node parent) {
        while (parent.getFirstChild() != null) {
            parent.getParentNode().insertBefore(parent.getFirstChild(), parent);
        }
        parent.getParentNode().removeChild(parent);
    }
}

