/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.xml.internal;

import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.component.annotation.Component;
import org.xwiki.diff.xml.XMLDiffPruner;
import org.xwiki.diff.xml.internal.XMLDiffUtils;

@Component
@Singleton
@Named(value="html")
public class HTMLDiffPruner
implements XMLDiffPruner {
    private static final String DIFF_CONTEXT_ATTRIBUTE = "data-xwiki-html-diff-context";
    private static final String DIFF_HIDDEN_ATTRIBUTE = "data-xwiki-html-diff-hidden";

    @Override
    public void prune(Node root) {
        this.getElementsWithAttribute(root, "data-xwiki-html-diff-block").stream().forEach(this::markContextElements);
        this.hideNodesWeDontWantToKeep(root);
        this.getElementsWithAttribute(root, DIFF_CONTEXT_ATTRIBUTE).stream().forEach(this::unmarkContextElement);
    }

    private void markContextElements(Node diffBlock) {
        for (Node node = diffBlock; node != null && node.getNodeType() == 1; node = node.getParentNode()) {
            this.markContextElement(node);
            this.getContextSiblings(node).stream().forEach(this::markContextElement);
        }
    }

    private void markContextElement(Node node) {
        Element element = (Element)node;
        if (!element.hasAttribute("data-xwiki-html-diff-block")) {
            element.setAttribute(DIFF_CONTEXT_ATTRIBUTE, String.valueOf(true));
        }
    }

    private void unmarkContextElement(Node node) {
        ((Element)node).removeAttribute(DIFF_CONTEXT_ATTRIBUTE);
    }

    private List<Node> getContextSiblings(Node node) {
        return Collections.emptyList();
    }

    private void hideNodesWeDontWantToKeep(Node node) {
        if (node.getNodeType() == 9) {
            this.hideNodesWeDontWantToKeep(((Document)node).getDocumentElement());
        } else if (node.getNodeType() == 1) {
            Element element = (Element)node;
            if (element.hasAttribute(DIFF_CONTEXT_ATTRIBUTE)) {
                XMLDiffUtils.asList(element.getChildNodes()).stream().forEach(this::hideNodesWeDontWantToKeep);
            } else if (!element.hasAttribute("data-xwiki-html-diff-block")) {
                element.setAttribute(DIFF_HIDDEN_ATTRIBUTE, String.valueOf(true));
            }
        }
    }

    private List<Node> getElementsWithAttribute(Node root, String attribute) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String expression = "//*[@" + attribute + "]";
        try {
            return XMLDiffUtils.asList((NodeList)xpath.compile(expression).evaluate(root, XPathConstants.NODESET));
        }
        catch (XPathExpressionException e) {
            return Collections.emptyList();
        }
    }
}

