/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.script;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.diff.DiffConfiguration;
import org.xwiki.diff.DiffException;
import org.xwiki.diff.DiffManager;
import org.xwiki.diff.DiffResult;
import org.xwiki.diff.MergeConfiguration;
import org.xwiki.diff.MergeException;
import org.xwiki.diff.MergeResult;
import org.xwiki.diff.internal.DefaultDiffResult;
import org.xwiki.diff.internal.DefaultMergeResult;
import org.xwiki.script.service.ScriptService;
import org.xwiki.script.service.ScriptServiceManager;

@Component
@Named(value="diff")
@Singleton
public class DiffScriptService
implements ScriptService {
    public static final String ROLEHINT = "diff";
    static final String DIFF_ERROR_KEY = "scriptservice.diff.error";
    @Inject
    private Execution execution;
    @Inject
    private DiffManager diffManager;
    @Inject
    private ScriptServiceManager scriptServiceManager;

    public <S extends ScriptService> S get(String serviceName) {
        return (S)this.scriptServiceManager.get("diff." + serviceName);
    }

    public <E> DiffResult<E> diff(List<E> previous, List<E> next, DiffConfiguration<E> configuration) {
        DiffResult result;
        try {
            result = this.diffManager.diff(previous, next, configuration);
        }
        catch (DiffException e) {
            result = new DefaultDiffResult(previous, next);
            result.getLog().error("Failed to execute diff", (Throwable)e);
        }
        return result;
    }

    public <E> MergeResult<E> merge(List<E> commonAncestor, List<E> next, List<E> current, MergeConfiguration<E> configuration) {
        MergeResult result;
        try {
            result = this.diffManager.merge(commonAncestor, next, current, configuration);
        }
        catch (MergeException e) {
            result = new DefaultMergeResult(commonAncestor, next, current);
            result.getLog().error("Failed to execute merge", (Throwable)e);
        }
        return result;
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(DIFF_ERROR_KEY);
    }
}

