/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.internal;

import java.util.List;
import org.xwiki.diff.Chunk;
import org.xwiki.diff.Delta;
import org.xwiki.diff.PatchException;
import org.xwiki.diff.internal.AbstractDelta;

public class DeleteDelta<E>
extends AbstractDelta<E> {
    public DeleteDelta(Chunk<E> previous, Chunk<E> next) {
        super(previous, next, Delta.Type.DELETE);
    }

    public DeleteDelta(com.github.difflib.patch.Chunk<E> original, com.github.difflib.patch.Chunk<E> revised) {
        super(original, revised, Delta.Type.DELETE);
    }

    @Override
    public void apply(List<E> target) throws PatchException {
        this.verify(target);
        int index = this.getPrevious().getIndex();
        int size = this.getPrevious().size();
        for (int i = 0; i < size; ++i) {
            target.remove(index);
        }
    }

    @Override
    public void restore(List<E> target) {
        int index = this.getNext().getIndex();
        List elements = this.getPrevious().getElements();
        for (int i = 0; i < elements.size(); ++i) {
            target.add(index + i, elements.get(i));
        }
    }

    @Override
    public void verify(List<E> target) throws PatchException {
        this.getPrevious().verify(target);
    }
}

