/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.internal.multi;

import jakarta.inject.Inject;
import java.lang.reflect.Type;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.internal.multi.ComponentManagerManager;
import org.xwiki.component.internal.multi.DelegateComponentManager;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentRepositoryException;

public abstract class AbstractGenericComponentManager
extends DelegateComponentManager {
    @Inject
    private ComponentManagerManager componentManagerManager;
    private ComponentManager internalParent;

    protected abstract String getKey();

    @Override
    public ComponentManager getComponentManager() {
        ComponentManager componentManager = this.getComponentManagerInternal();
        if (componentManager == null && (componentManager = this.getInternalParent()) == null) {
            throw new RuntimeException("Key-based Proxy Component Managers should always have a Parent Component Manager defined so that it can be used if there's no Component Manager for the given key");
        }
        return componentManager;
    }

    protected ComponentManager getComponentManagerInternal() {
        String key = this.getKey();
        return key != null ? this.componentManagerManager.getComponentManager(key, false) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void registerComponent(ComponentDescriptor<T> componentDescriptor, T componentInstance) throws ComponentRepositoryException {
        AbstractGenericComponentManager abstractGenericComponentManager = this;
        synchronized (abstractGenericComponentManager) {
            ComponentManager componentManager = this.componentManagerManager.getComponentManager(this.getKey(), true);
            if (componentInstance == null) {
                componentManager.registerComponent(componentDescriptor);
            } else {
                componentManager.registerComponent(componentDescriptor, componentInstance);
            }
        }
    }

    @Override
    public <T> void registerComponent(ComponentDescriptor<T> componentDescriptor) throws ComponentRepositoryException {
        this.registerComponent(componentDescriptor, null);
    }

    @Override
    public void unregisterComponent(Type role, String roleHint) {
        super.unregisterComponent(role, roleHint);
    }

    protected ComponentManager getInternalParent() {
        return this.internalParent;
    }

    protected void setInternalParent(ComponentManager parentComponentManager) {
        this.internalParent = parentComponentManager;
    }
}

