/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDependency;
import org.xwiki.component.descriptor.DefaultComponentRole;
import org.xwiki.text.XWikiToStringBuilder;

public class DefaultComponentDescriptor<T>
extends DefaultComponentRole<T>
implements ComponentDescriptor<T> {
    private Class<? extends T> implementation;
    private ComponentInstantiationStrategy instantiationStrategy = ComponentInstantiationStrategy.SINGLETON;
    private List<ComponentDependency<?>> componentDependencies = new ArrayList();
    private boolean mandatory;
    private int roleTypePriority = 1000;
    private int roleHintPriority = 1000;

    public DefaultComponentDescriptor() {
    }

    public DefaultComponentDescriptor(ComponentDescriptor<T> descriptor) {
        super(descriptor);
        this.setImplementation(descriptor.getImplementation());
        this.setInstantiationStrategy(descriptor.getInstantiationStrategy());
        for (ComponentDependency<?> dependency : descriptor.getComponentDependencies()) {
            this.addComponentDependency(new DefaultComponentDependency(dependency));
        }
        this.setMandatory(descriptor.isMandatory());
        this.setRoleTypePriority(descriptor.getRoleTypePriority());
        this.setRoleHintPriority(descriptor.getRoleHintPriority());
    }

    public void setImplementation(Class<? extends T> implementation) {
        this.implementation = implementation;
    }

    @Override
    public Class<? extends T> getImplementation() {
        return this.implementation;
    }

    public void setInstantiationStrategy(ComponentInstantiationStrategy instantiationStrategy) {
        this.instantiationStrategy = instantiationStrategy;
    }

    @Override
    public ComponentInstantiationStrategy getInstantiationStrategy() {
        return this.instantiationStrategy;
    }

    @Override
    public Collection<ComponentDependency<?>> getComponentDependencies() {
        return this.componentDependencies;
    }

    public void addComponentDependency(ComponentDependency<?> componentDependency) {
        this.componentDependencies.add(componentDependency);
    }

    public <D> void addComponentDependency(Class<D> role, String roleHint) {
        DefaultComponentDependency<D> componentDependency = new DefaultComponentDependency<D>();
        componentDependency.setRole(role);
        componentDependency.setRoleHint(roleHint);
        this.componentDependencies.add(componentDependency);
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    @Override
    public int getRoleTypePriority() {
        return this.roleTypePriority;
    }

    public void setRoleTypePriority(int roleTypePriority) {
        this.roleTypePriority = roleTypePriority;
    }

    @Override
    public int getRoleHintPriority() {
        return this.roleHintPriority;
    }

    public void setRoleHintPriority(int roleHintPriority) {
        this.roleHintPriority = roleHintPriority;
    }

    @Override
    public String toString() {
        XWikiToStringBuilder builder = new XWikiToStringBuilder((Object)this);
        builder.appendSuper(super.toString());
        builder.append("implementation", this.getImplementation() == null ? null : this.getImplementation().getName());
        builder.append("instantiation", (Object)this.getInstantiationStrategy());
        builder.append("mandatory", this.isMandatory());
        builder.append("roleTypePriority", this.getRoleTypePriority());
        builder.append("roleHintPriority", this.getRoleHintPriority());
        return builder.toString();
    }

    @Override
    public boolean equals(Object object) {
        boolean result;
        if (this == object) {
            result = true;
        } else if (object == null || object.getClass() != this.getClass()) {
            result = false;
        } else {
            ComponentDescriptor cd = (ComponentDescriptor)object;
            EqualsBuilder builder = new EqualsBuilder();
            builder.appendSuper(super.equals(object));
            builder.append(this.getImplementation(), cd.getImplementation());
            builder.append((Object)this.getInstantiationStrategy(), (Object)cd.getInstantiationStrategy());
            builder.append(this.getComponentDependencies(), cd.getComponentDependencies());
            builder.append(this.isMandatory(), cd.isMandatory());
            builder.append(this.getRoleTypePriority(), cd.getRoleTypePriority());
            builder.append(this.getRoleHintPriority(), cd.getRoleHintPriority());
            return builder.build();
        }
        return result;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(super.hashCode());
        builder.append(this.getImplementation());
        builder.append((Object)this.getInstantiationStrategy());
        builder.append(this.getComponentDependencies());
        builder.append(this.isMandatory());
        builder.append(this.getRoleTypePriority());
        builder.append(this.getRoleHintPriority());
        return builder.toHashCode();
    }
}

