/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.internal.multi;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.internal.multi.ComponentManagerFactory;
import org.xwiki.component.internal.multi.ComponentManagerManager;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.namespace.NamespaceUtils;

@Component
@Singleton
public class DefaultComponentManagerManager
implements ComponentManagerManager {
    @Inject
    private ComponentManagerFactory defaultComponentManagerFactory;
    @Inject
    private ComponentManager rootComponentManager;
    private Map<String, ComponentManager> componentManagers = new ConcurrentHashMap<String, ComponentManager>();

    @Override
    public ComponentManager getComponentManager(String namespace, boolean create) {
        ComponentManager componentManager;
        if (namespace == null) {
            componentManager = this.rootComponentManager;
        } else {
            componentManager = this.componentManagers.get(namespace);
            if (componentManager == null && create) {
                componentManager = this.createComponentManager(namespace);
                this.componentManagers.put(namespace, componentManager);
            }
        }
        return componentManager;
    }

    private ComponentManager createComponentManager(String namespace) {
        ComponentManagerFactory componentManagerFactory;
        String prefix = NamespaceUtils.getPrefix(namespace);
        try {
            componentManagerFactory = (ComponentManagerFactory)this.rootComponentManager.getInstance((Type)((Object)ComponentManagerFactory.class), prefix);
        }
        catch (ComponentLookupException e) {
            componentManagerFactory = this.defaultComponentManagerFactory;
        }
        return componentManagerFactory.createComponentManager(namespace, this.rootComponentManager);
    }
}

