/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.classloader.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.xwiki.classloader.ExtendedURLStreamHandler;
import org.xwiki.classloader.internal.ExtendedJarURLConnection;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.environment.Environment;

@Component
@Named(value="jar")
@Singleton
public class JarExtendedURLStreamHandler
extends URLStreamHandler
implements ExtendedURLStreamHandler,
Initializable,
Disposable {
    public static final String PROTOCOL = "jar";
    public static final String JARS_FOLDER = "classloader/jars/";
    @Inject
    private URLStreamHandlerFactory handlerFactory;
    @Inject
    private Provider<Environment> environmentProvider;
    @Inject
    private Logger logger;
    private File jarsDirectory;

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }

    private URLStreamHandler getURLStreamHandler(String spec) {
        int index = spec.indexOf(58, PROTOCOL.length() + 1);
        if (index != -1) {
            String hint = spec.substring(PROTOCOL.length() + 1, index);
            return this.handlerFactory.createURLStreamHandler(hint);
        }
        return null;
    }

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        String spec = u.toExternalForm();
        URLStreamHandler subHandler = this.getURLStreamHandler(spec);
        if (subHandler != null) {
            return new ExtendedJarURLConnection(u, subHandler, this.jarsDirectory);
        }
        return new URL(null, spec).openConnection();
    }

    public void initialize() throws InitializationException {
        File temporaryDirectory;
        try {
            Environment environment = (Environment)this.environmentProvider.get();
            temporaryDirectory = environment.getTemporaryDirectory();
        }
        catch (Exception e) {
            try {
                temporaryDirectory = Files.createTempDirectory("xwiki", new FileAttribute[0]).toFile();
            }
            catch (IOException e1) {
                throw new InitializationException(JARS_FOLDER);
            }
        }
        this.jarsDirectory = new File(temporaryDirectory, JARS_FOLDER);
    }

    public void dispose() throws ComponentLifecycleException {
        if (this.jarsDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.jarsDirectory);
            }
            catch (IOException e) {
                this.logger.error("Failed to delete folder [{}]", (Object)this.jarsDirectory);
            }
        }
    }

    private static int indexOfBangSlash(String spec) {
        int indexOfBang = spec.length();
        while ((indexOfBang = spec.lastIndexOf(33, indexOfBang)) != -1) {
            if (indexOfBang != spec.length() - 1 && spec.charAt(indexOfBang + 1) == '/') {
                return indexOfBang + 1;
            }
            --indexOfBang;
        }
        return -1;
    }

    public String checkNestedProtocol(String spec) {
        if (spec.regionMatches(true, 0, "jar:", 0, 4)) {
            return "Nested JAR URLs are not supported";
        }
        return null;
    }

    @Override
    protected void parseURL(URL url, String spec, int start, int limit) {
        boolean refOnly;
        Object file = null;
        String ref = null;
        int refPos = spec.indexOf(35, limit);
        boolean bl = refOnly = refPos == start;
        if (refPos > -1) {
            ref = spec.substring(refPos + 1, spec.length());
            if (refOnly) {
                file = url.getFile();
            }
        }
        boolean absoluteSpec = spec.length() >= 4 ? spec.regionMatches(true, 0, "jar:", 0, 4) : false;
        String exceptionMessage = this.checkNestedProtocol(spec = spec.substring(start, limit));
        if (exceptionMessage != null) {
            throw new NullPointerException(exceptionMessage);
        }
        if (absoluteSpec) {
            file = this.parseAbsoluteSpec(spec);
        } else if (!refOnly) {
            file = this.parseContextSpec(url, spec);
            int bangSlash = JarExtendedURLStreamHandler.indexOfBangSlash((String)file);
            String toBangSlash = ((String)file).substring(0, bangSlash);
            String afterBangSlash = ((String)file).substring(bangSlash);
            afterBangSlash = JarExtendedURLStreamHandler.canonizeString(afterBangSlash);
            file = toBangSlash + afterBangSlash;
        }
        this.setURL(url, PROTOCOL, "", -1, (String)file, ref);
    }

    private String parseAbsoluteSpec(String spec) {
        int index = JarExtendedURLStreamHandler.indexOfBangSlash(spec);
        if (index == -1) {
            throw new NullPointerException("no !/ in spec");
        }
        try {
            String innerSpec = spec.substring(0, index - 1);
            new URL(innerSpec);
        }
        catch (MalformedURLException e) {
            throw new NullPointerException("invalid url: " + spec + " (" + e + ")");
        }
        return spec;
    }

    private String parseContextSpec(URL url, String spec) {
        String ctxFile = url.getFile();
        if (spec.startsWith("/")) {
            int bangSlash = JarExtendedURLStreamHandler.indexOfBangSlash(ctxFile);
            if (bangSlash == -1) {
                throw new NullPointerException("malformed context url:" + url + ": no !/");
            }
            ctxFile = ctxFile.substring(0, bangSlash);
        } else {
            int lastSlash = ctxFile.lastIndexOf(47);
            if (lastSlash == -1) {
                throw new NullPointerException("malformed context url:" + url);
            }
            if (lastSlash < ctxFile.length() - 1) {
                ctxFile = ctxFile.substring(0, lastSlash + 1);
            }
        }
        return ctxFile + spec;
    }

    public static String canonizeString(String file) {
        int len = file.length();
        if (len == 0 || file.indexOf("./") == -1 && file.charAt(len - 1) != '.') {
            return file;
        }
        return JarExtendedURLStreamHandler.doCanonize(file);
    }

    private static String doCanonize(String file) {
        int lim;
        int i;
        while ((i = ((String)file).indexOf("/../")) >= 0) {
            lim = ((String)file).lastIndexOf(47, i - 1);
            if (lim >= 0) {
                file = ((String)file).substring(0, lim) + ((String)file).substring(i + 3);
                continue;
            }
            file = ((String)file).substring(i + 3);
        }
        while ((i = ((String)file).indexOf("/./")) >= 0) {
            file = ((String)file).substring(0, i) + ((String)file).substring(i + 2);
        }
        while (((String)file).endsWith("/..")) {
            i = ((String)file).indexOf("/..");
            lim = ((String)file).lastIndexOf(47, i - 1);
            if (lim >= 0) {
                file = ((String)file).substring(0, lim + 1);
                continue;
            }
            file = ((String)file).substring(0, i);
        }
        if (((String)file).endsWith("/.")) {
            file = ((String)file).substring(0, ((String)file).length() - 1);
        }
        return file;
    }
}

