/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3;

import org.assertj.core.api.AbstractAssert;
import org.w3c.dom.Node;
import org.xmlunit.assertj3.NodeUtils;
import org.xmlunit.assertj3.error.ShouldHaveAttribute;
import org.xmlunit.assertj3.error.ShouldHaveXPath;
import org.xmlunit.assertj3.error.ShouldNotHaveAttribute;
import org.xmlunit.xpath.JAXPXPathEngine;

public class SingleNodeAssert
extends AbstractAssert<SingleNodeAssert, Node> {
    private final JAXPXPathEngine engine;

    SingleNodeAssert(Node node, JAXPXPathEngine engine) {
        super((Object)node, SingleNodeAssert.class);
        this.engine = engine;
    }

    public SingleNodeAssert hasAttribute(String attributeName) {
        this.isNotNull();
        String value = NodeUtils.attributeValue((Node)this.actual, attributeName);
        if (value == null) {
            this.throwAssertionError(ShouldHaveAttribute.shouldHaveAttribute(((Node)this.actual).getNodeName(), attributeName));
        }
        return this;
    }

    public SingleNodeAssert hasAttribute(String attributeName, String attributeValue) {
        this.isNotNull();
        String value = NodeUtils.attributeValue((Node)this.actual, attributeName);
        if (value == null || !value.equals(attributeValue)) {
            this.throwAssertionError(ShouldHaveAttribute.shouldHaveAttributeWithValue(((Node)this.actual).getNodeName(), attributeName, attributeValue));
        }
        return this;
    }

    public SingleNodeAssert doesNotHaveAttribute(String attributeName) {
        this.isNotNull();
        String value = NodeUtils.attributeValue((Node)this.actual, attributeName);
        if (value != null) {
            this.throwAssertionError(ShouldNotHaveAttribute.shouldNotHaveAttribute(((Node)this.actual).getNodeName(), attributeName));
        }
        return this;
    }

    public SingleNodeAssert doesNotHaveAttribute(String attributeName, String attributeValue) {
        this.isNotNull();
        String value = NodeUtils.attributeValue((Node)this.actual, attributeName);
        if (value != null && value.equals(attributeValue)) {
            this.throwAssertionError(ShouldNotHaveAttribute.shouldNotHaveAttributeWithValue(((Node)this.actual).getNodeName(), attributeName, attributeValue));
        }
        return this;
    }

    public SingleNodeAssert hasXPath(String xPath) {
        this.isNotNull();
        if (this.isNodeSetEmpty(xPath)) {
            this.throwAssertionError(ShouldHaveXPath.shouldHaveXPath(((Node)this.actual).getNodeName(), xPath));
        }
        return this;
    }

    boolean isNodeSetEmpty(String xPath) {
        return !this.engine.selectNodes(xPath, (Node)this.actual).iterator().hasNext();
    }
}

