/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.types;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.xmlbeam.types.StringConstructorConversion;
import org.xmlbeam.types.StringFactoryConversion;
import org.xmlbeam.types.StringRenderer;
import org.xmlbeam.types.TypeConverter;
import org.xmlbeam.util.intern.ReflectionHelper;

public class DefaultTypeConverter
implements TypeConverter,
StringRenderer {
    private final Map<Class<?>, Conversion<?>> CONVERSIONS = new HashMap();
    private Locale locale;
    private TimeZone timezone;
    private DecimalFormat decimalFormat;

    public DefaultTypeConverter(final Locale locale, final TimeZone timezone) {
        this.setLocale(locale);
        this.setTimeZone(timezone);
        this.CONVERSIONS.put(Boolean.class, new Conversion<Boolean>(null){

            @Override
            public Boolean convert(String data) {
                return Boolean.valueOf(data.trim());
            }
        });
        this.CONVERSIONS.put(Boolean.TYPE, new Conversion<Boolean>(Boolean.valueOf(false)){

            @Override
            public Boolean convert(String data) {
                return Boolean.valueOf(data.trim());
            }
        });
        this.CONVERSIONS.put(Byte.class, new Conversion<Byte>(null){

            @Override
            public Byte convert(String data) {
                return Byte.valueOf(data.trim());
            }

            @Override
            public Byte convertWithPattern(String data, String pattern) {
                return DefaultTypeConverter.this.parseWithPattern(data, pattern).byteValue();
            }
        });
        this.CONVERSIONS.put(Byte.TYPE, new Conversion<Byte>(Byte.valueOf((byte)0)){

            @Override
            public Byte convert(String data) {
                return Byte.valueOf(data.trim());
            }

            @Override
            public Byte convertWithPattern(String data, String pattern) {
                return DefaultTypeConverter.this.parseWithPattern(data, pattern).byteValue();
            }
        });
        this.CONVERSIONS.put(Float.class, new Conversion<Float>(null){

            @Override
            public Float convert(String data) {
                return Float.valueOf(data.trim());
            }

            @Override
            public Float convertWithPattern(String data, String pattern) {
                return Float.valueOf(DefaultTypeConverter.this.parseWithPattern(data, pattern).floatValue());
            }
        });
        this.CONVERSIONS.put(Float.TYPE, new Conversion<Float>(Float.valueOf(0.0f)){

            @Override
            public Float convert(String data) {
                return Float.valueOf(data.trim());
            }

            @Override
            public Float convertWithPattern(String data, String pattern) {
                return Float.valueOf(DefaultTypeConverter.this.parseWithPattern(data, pattern).floatValue());
            }
        });
        this.CONVERSIONS.put(Double.class, new Conversion<Double>(null){

            @Override
            public Double convert(String data) {
                return Double.valueOf(data.trim());
            }

            @Override
            public Double convertWithPattern(String data, String pattern) {
                return DefaultTypeConverter.this.parseWithPattern(data, pattern).doubleValue();
            }
        });
        this.CONVERSIONS.put(Double.TYPE, new Conversion<Double>(Double.valueOf(0.0)){

            @Override
            public Double convert(String data) {
                return Double.valueOf(data.trim());
            }

            @Override
            public Double convertWithPattern(String data, String pattern) {
                return DefaultTypeConverter.this.parseWithPattern(data, pattern).doubleValue();
            }
        });
        this.CONVERSIONS.put(Short.class, new Conversion<Short>(null){

            @Override
            public Short convert(String data) {
                return Short.valueOf(data.trim());
            }

            @Override
            public Short convertWithPattern(String data, String pattern) {
                return DefaultTypeConverter.this.parseWithPattern(data, pattern).shortValue();
            }
        });
        this.CONVERSIONS.put(Short.TYPE, new Conversion<Short>(Short.valueOf((short)0)){

            @Override
            public Short convert(String data) {
                return Short.valueOf(data.trim());
            }

            @Override
            public Short convertWithPattern(String data, String pattern) {
                return DefaultTypeConverter.this.parseWithPattern(data, pattern).shortValue();
            }
        });
        this.CONVERSIONS.put(Integer.class, new Conversion<Integer>(null){

            @Override
            public Integer convert(String data) {
                return Integer.valueOf(data.trim());
            }

            @Override
            public Integer convertWithPattern(String data, String pattern) {
                return DefaultTypeConverter.this.parseWithPattern(data, pattern).intValue();
            }
        });
        this.CONVERSIONS.put(Integer.TYPE, new Conversion<Integer>(Integer.valueOf(0)){

            @Override
            public Integer convert(String data) {
                return Integer.valueOf(data.trim());
            }

            @Override
            public Integer convertWithPattern(String data, String pattern) {
                return DefaultTypeConverter.this.parseWithPattern(data, pattern).intValue();
            }
        });
        this.CONVERSIONS.put(Long.class, new Conversion<Long>(null){

            @Override
            public Long convert(String data) {
                return Long.valueOf(data.trim());
            }

            @Override
            public Long convertWithPattern(String data, String pattern) {
                return DefaultTypeConverter.this.parseWithPattern(data, pattern).longValue();
            }
        });
        this.CONVERSIONS.put(Long.TYPE, new Conversion<Long>(Long.valueOf(0L)){

            @Override
            public Long convert(String data) {
                return Long.valueOf(data.trim());
            }

            @Override
            public Long convertWithPattern(String data, String pattern) {
                return DefaultTypeConverter.this.parseWithPattern(data, pattern).longValue();
            }
        });
        this.CONVERSIONS.put(Character.class, new Conversion<Character>(null){

            @Override
            public Character convert(String data) {
                if (data.length() == 1) {
                    return Character.valueOf(data.charAt(0));
                }
                String trimmed = data.trim();
                return Character.valueOf(trimmed.isEmpty() ? ((Character)this.getDefaultValue("")).charValue() : trimmed.charAt(0));
            }
        });
        this.CONVERSIONS.put(Character.TYPE, new Conversion<Character>(Character.valueOf(' ')){

            @Override
            public Character convert(String data) {
                if (data.length() == 1) {
                    return Character.valueOf(data.charAt(0));
                }
                String trimmed = data.trim();
                return Character.valueOf(trimmed.isEmpty() ? ((Character)this.getDefaultValue("")).charValue() : trimmed.charAt(0));
            }
        });
        this.CONVERSIONS.put(String.class, new Conversion<String>(null){

            @Override
            public String convert(String data) {
                return data;
            }
        });
        this.CONVERSIONS.put(Date.class, new Conversion<Date>(null){

            @Override
            public Date convert(String data) {
                try {
                    return DateFormat.getTimeInstance(3, locale).parse(data);
                }
                catch (ParseException e) {
                    NumberFormatException exception = new NumberFormatException(data);
                    exception.initCause(e);
                    throw exception;
                }
            }

            @Override
            public Date convertWithPattern(String data, String pattern) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, DateFormatSymbols.getInstance(locale));
                dateFormat.setTimeZone(timezone);
                try {
                    return dateFormat.parse(data);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
        this.CONVERSIONS.put(BigDecimal.class, new Conversion<BigDecimal>(null){

            @Override
            public BigDecimal convert(String data) {
                return new BigDecimal(data);
            }

            @Override
            public BigDecimal convertWithPattern(String data, String pattern) {
                DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(locale);
                decimalFormat.setParseBigDecimal(true);
                try {
                    return (BigDecimal)decimalFormat.parseObject(data);
                }
                catch (ParseException e) {
                    NumberFormatException exception = new NumberFormatException(data);
                    exception.initCause(e);
                    throw exception;
                }
            }
        });
        this.CONVERSIONS.put(Number.class, new Conversion<Number>(null){

            @Override
            public Number convert(String data) {
                try {
                    return NumberFormat.getInstance(locale).parse(data);
                }
                catch (ParseException e) {
                    NumberFormatException exception = new NumberFormatException(data);
                    exception.initCause(e);
                    throw exception;
                }
            }

            @Override
            public Number convertWithPattern(String data, String pattern) {
                return DefaultTypeConverter.this.parseWithPattern(data, pattern);
            }
        });
    }

    protected Number parseWithPattern(String data, String pattern) {
        this.decimalFormat.applyPattern(pattern);
        try {
            return this.decimalFormat.parse(data);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("can not parse '" + data + "' with pattern '" + pattern + "'", e);
        }
    }

    @Override
    public <T> T convertTo(Class<T> targetType, String data, String ... optionalFormatPattern) {
        Conversion<?> conversion = this.CONVERSIONS.get(targetType);
        assert (conversion != null) : "Method caller must check existence of conversion. (" + targetType.getName() + ")";
        if (data == null) {
            return (T)conversion.getDefaultValue(data);
        }
        if (optionalFormatPattern != null && optionalFormatPattern.length > 0 && optionalFormatPattern[0] != null) {
            return (T)conversion.convertWithPattern(data, optionalFormatPattern[0]);
        }
        return (T)conversion.convert(data);
    }

    @Override
    public <T> boolean isConvertable(Class<T> targetType) {
        if (targetType == null) {
            return false;
        }
        if (this.CONVERSIONS.containsKey(targetType)) {
            return true;
        }
        Constructor<T> constructor = ReflectionHelper.getCallableConstructorForParams(targetType, String.class);
        if (constructor != null) {
            this.CONVERSIONS.put(targetType, new StringConstructorConversion<Object>(constructor, null));
            return true;
        }
        Method factory = ReflectionHelper.getCallableFactoryForParams(targetType, String.class);
        if (factory != null) {
            this.CONVERSIONS.put(targetType, new StringFactoryConversion<Object>(factory, null));
            return true;
        }
        return false;
    }

    public <T> DefaultTypeConverter setConversionForType(Class<T> type, Conversion<T> conversion) {
        assert (type != null);
        if (conversion == null) {
            this.CONVERSIONS.remove(type);
            return this;
        }
        this.CONVERSIONS.put(type, conversion);
        return this;
    }

    public DefaultTypeConverter setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("You must provide a Locale, not null");
        }
        NumberFormat format = NumberFormat.getInstance(locale);
        if (!(format instanceof DecimalFormat)) {
            throw new IllegalArgumentException("Can not find a DecimalFormat for locale " + locale);
        }
        this.decimalFormat = (DecimalFormat)format;
        this.locale = locale;
        return this;
    }

    public DefaultTypeConverter setTimeZone(TimeZone timezone) {
        if (timezone == null) {
            throw new IllegalArgumentException("You must provide a timezone, not null");
        }
        this.timezone = timezone;
        return this;
    }

    @Override
    public <T> String render(Class<? extends T> dataType, T data, String ... optionalFormatPattern) {
        assert (dataType != null);
        if (optionalFormatPattern == null || optionalFormatPattern.length == 0 || optionalFormatPattern[0] == null) {
            return data == null ? null : data.toString();
        }
        if (Date.class.isAssignableFrom(dataType)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(optionalFormatPattern[0], DateFormatSymbols.getInstance(this.locale));
            dateFormat.setTimeZone(this.timezone);
            return dateFormat.format(data);
        }
        if (this.isNumber(dataType)) {
            DecimalFormat clone = (DecimalFormat)this.decimalFormat.clone();
            clone.applyPattern(optionalFormatPattern[0]);
            return clone.format(data);
        }
        throw new IllegalArgumentException("Type " + data.getClass().getSimpleName() + " can not be formatted using a pattern");
    }

    private boolean isNumber(Class<?> dataType) {
        if (Number.class.isAssignableFrom(dataType)) {
            return true;
        }
        if (Integer.TYPE.equals(dataType)) {
            return true;
        }
        if (Long.TYPE.equals(dataType)) {
            return true;
        }
        if (Short.TYPE.equals(dataType)) {
            return true;
        }
        if (Float.TYPE.equals(dataType)) {
            return true;
        }
        return Double.TYPE.equals(dataType);
    }

    public static abstract class Conversion<T>
    implements Serializable {
        private final T defaultValue;

        protected Conversion(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        public abstract T convert(String var1);

        public T getDefaultValue(String data) {
            return this.defaultValue;
        }

        public T convertWithPattern(String data, String pattern) {
            throw new IllegalArgumentException("Can not convert type " + this.getClass().getSimpleName() + " with format pattern.");
        }
    }
}

