/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.externalizer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Properties;
import org.xmlbeam.exceptions.XBException;
import org.xmlbeam.exceptions.XBIOException;
import org.xmlbeam.externalizer.Externalizer;

public class PropertyFileExternalizer
implements Externalizer {
    private static final long serialVersionUID = -2752447643606854521L;
    private final File propertyFile;
    private final Properties props = new Properties();
    private final boolean useXmlFormat;
    private long lastReadTS = 0L;
    private String encodingName = "ISO8859-1";

    public PropertyFileExternalizer(File propertyFile) {
        this.propertyFile = propertyFile;
        this.useXmlFormat = false;
    }

    public PropertyFileExternalizer(File propertyFile, boolean useXmlFormat) {
        this.propertyFile = propertyFile;
        this.useXmlFormat = useXmlFormat;
    }

    public PropertyFileExternalizer setEncoding(String encodingName) {
        this.encodingName = encodingName;
        return this;
    }

    private void updateProps() {
        if (!this.propertyFile.canRead()) {
            throw new XBException((CharSequence)("Can not read file '" + this.propertyFile + "'"));
        }
        long fileTS = this.propertyFile.lastModified();
        if (this.lastReadTS > fileTS) {
            return;
        }
        this.props.clear();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this.propertyFile);
            if (this.useXmlFormat) {
                this.props.loadFromXML(inputStream);
                return;
            }
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, this.encodingName);
            this.props.load(reader);
        }
        catch (IOException e) {
            throw new XBIOException("Error while reading file '" + this.propertyFile + "'", e);
        }
        finally {
            this.lastReadTS = fileTS;
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new XBIOException("Can not close file '" + this.propertyFile + "'", e);
                }
            }
        }
    }

    @Override
    public String resolveXPath(String annotationValue, Method method, Object[] args) {
        this.updateProps();
        return this.findProperty(annotationValue, method, args);
    }

    @Override
    public String resolveURL(String annotationValue, Method method, Object[] args) {
        this.updateProps();
        return this.findProperty(annotationValue, method, args);
    }

    protected String findProperty(String key, Method method, Object[] args) {
        String[] propNameCandidates;
        for (String propName : propNameCandidates = new String[]{method.getDeclaringClass().getName() + "." + method.getName(), method.getDeclaringClass().getSimpleName() + "." + method.getName(), method.getName(), key}) {
            if (!this.props.containsKey(propName)) continue;
            return this.props.getProperty(propName);
        }
        throw new IllegalArgumentException("Expected to find property with key '" + key + "' in file " + this.propertyFile.getAbsolutePath() + " for method " + method + ". But it does not exist.");
    }
}

