/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.businessprocess.integration.common.utils;

import java.rmi.RemoteException;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.ei.businessprocess.integration.common.clients.ServiceAdminClient;

public class ServiceDeploymentUtil {
    private static int SERVICE_DEPLOYMENT_DELAY = 90000;
    private static Log log = LogFactory.getLog(ServiceDeploymentUtil.class);

    public static boolean isServiceDeployed(String backEndUrl, String sessionCookie, String serviceName) throws RemoteException {
        long time;
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Service deployment " + serviceName));
        boolean isServiceDeployed = false;
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            if (adminServiceService.isServiceExists(serviceName)) {
                isServiceDeployed = true;
                log.info((Object)(serviceName + " Service Deployed in " + time + " millis"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isServiceDeployed;
    }

    public static boolean isServiceDeleted(String backEndUrl, String sessionCookie, String serviceName) throws RemoteException {
        long time;
        log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for service un-deployment"));
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        boolean isServiceDeleted = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            if (!adminServiceService.isServiceExists(serviceName)) {
                isServiceDeleted = true;
                log.info((Object)(serviceName + " Service un-deployed in " + time + " millis"));
                break;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isServiceDeleted;
    }

    public static boolean isServiceExist(String backEndUrl, String sessionCookie, String serviceName) throws RemoteException {
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        return adminServiceService.isServiceExists(serviceName);
    }

    public static boolean isFaultyService(String backEndUrl, String sessionCookie, String serviceName) throws RemoteException {
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        return adminServiceService.isServiceFaulty(serviceName);
    }

    public static boolean isServiceUnDeployed(String backEndUrl, String sessionCookie, String serviceName, int deploymentDelay) throws RemoteException {
        long time;
        log.info((Object)("waiting " + deploymentDelay + " millis for Service undeployment"));
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        boolean isServiceDeleted = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)deploymentDelay) {
            if (!adminServiceService.isServiceExists(serviceName)) {
                isServiceDeleted = true;
                log.info((Object)(serviceName + " Service undeployed in " + time + " millis"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isServiceDeleted;
    }
}

