/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils;

import java.rmi.RemoteException;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.test.utils.common.EmailSender;
import org.wso2.carbon.integration.common.admin.client.LogViewerClient;
import org.wso2.carbon.logging.view.stub.LogViewerLogViewerException;
import org.wso2.carbon.logging.view.stub.types.carbon.LogEvent;
import org.wso2.esb.integration.common.utils.exception.ESBMailTransportIntegrationTestException;

public class MailToTransportUtil {
    protected static Log log = LogFactory.getLog(MailToTransportUtil.class);
    private static String sender;
    private static char[] senderPassword;
    private static String receiver;
    private static char[] receiverPassword;
    private static String domain;
    private static int WAIT_TIME_MS;
    private static final String EMAIL_INBOX = "INBOX";
    private static final String EMAIL_CREDENTIAL_PARENT_XPATH = "//emailCredentials";
    private static final String EMAIL_CREDENTIAL_SENDER_XPATH = "//emailCredentials/sender";
    private static final String EMAIL_CREDENTIAL_SENDER_PASSWORD_XPATH = "//emailCredentials/senderPassword";
    private static final String EMAIL_CREDENTIAL_RECEIVER_XPATH = "//emailCredentials/receiver";
    private static final String EMAIL_CREDENTIAL_RECEIVER_PASSWORD_XPATH = "//emailCredentials/receiverPassword";
    private static final String EMAIL_CREDENTIAL_DOMAIN_XPATH = "//emailCredentials/domain";

    public static Properties getSMTPProperties() {
        Properties props = new Properties();
        props.put("mail.smtp.host", "smtp.gmail.com");
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.debug", "true");
        props.put("mail.smtp.socketFactory.port", "465");
        props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.put("mail.smtp.socketFactory.fallback", "false");
        props.put("mail.smtp.starttls.enable", "true");
        return props;
    }

    public static boolean sendMailAndCheckReceived(String emailSubject) throws Exception {
        Properties props = MailToTransportUtil.getSMTPProperties();
        boolean isEmailReceived = false;
        EmailSender emailSender = new EmailSender(props, sender, String.valueOf(senderPassword), domain, receiver + "@" + domain);
        if (emailSender.createSession()) {
            emailSender.setSubject(emailSubject);
            emailSender.setBody("Body : " + emailSubject);
            emailSender.sendEmail();
            log.info((Object)("Email send by Mail API successfully : " + emailSubject));
            isEmailReceived = MailToTransportUtil.waitToCheckEmailReceived(emailSubject, EMAIL_INBOX);
        }
        return isEmailReceived;
    }

    public static boolean isMailReceivedBySubject(String emailSubject, String folder) throws ESBMailTransportIntegrationTestException {
        boolean emailReceived = false;
        Store store = MailToTransportUtil.getConnection();
        try {
            Message[] messages;
            Folder mailFolder = store.getFolder(folder);
            mailFolder.open(2);
            AndTerm searchTerm = new AndTerm((SearchTerm)new SubjectTerm(emailSubject), (SearchTerm)new BodyTerm(emailSubject));
            for (Message message : messages = mailFolder.search((SearchTerm)searchTerm)) {
                if (!message.getSubject().contains(emailSubject)) continue;
                log.info((Object)("Found the email emailSubject : " + emailSubject));
                emailReceived = true;
                break;
            }
            boolean bl = emailReceived;
            return bl;
        }
        catch (MessagingException ex) {
            log.error((Object)"Error when getting mail count ", (Throwable)ex);
            throw new ESBMailTransportIntegrationTestException("Error when getting mail count ", ex);
        }
        finally {
            if (store != null) {
                try {
                    store.close();
                }
                catch (MessagingException e) {
                    log.warn((Object)"Error when closing the store ", (Throwable)e);
                }
            }
        }
    }

    public static boolean checkDeletedEmail(String emailSubject) throws ESBMailTransportIntegrationTestException {
        boolean isEmailDeleted = false;
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)WAIT_TIME_MS) {
            if (!MailToTransportUtil.isMailReceivedBySubject(emailSubject, EMAIL_INBOX)) {
                log.info((Object)"Email has deleted successfully");
                isEmailDeleted = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                log.warn((Object)"Error while sleep the thread for 0.5 sec");
            }
        }
        return isEmailDeleted;
    }

    private static Store getConnection() throws ESBMailTransportIntegrationTestException {
        Properties properties = new Properties();
        properties.setProperty("mail.host", "imap.gmail.com");
        properties.setProperty("mail.port", "995");
        properties.setProperty("mail.transport.protocol", "imaps");
        Session session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(receiver + "@" + domain, String.valueOf(receiverPassword));
            }
        });
        try {
            Store store = session.getStore("imaps");
            store.connect();
            return store;
        }
        catch (MessagingException e) {
            log.error((Object)"Error when creating the email store ", (Throwable)e);
            throw new ESBMailTransportIntegrationTestException("Error when creating the email store ", e);
        }
    }

    public static void deleteAllUnreadEmailsFromGmail() throws ESBMailTransportIntegrationTestException {
        Folder inbox = null;
        Store store = MailToTransportUtil.getConnection();
        try {
            Message[] messages;
            inbox = store.getFolder(EMAIL_INBOX);
            inbox.open(2);
            for (Message message : messages = inbox.search((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), false))) {
                message.setFlag(Flags.Flag.DELETED, true);
                log.info((Object)("Deleted email Subject : " + message.getSubject()));
            }
        }
        catch (MessagingException e) {
            log.error((Object)"Error when deleting emails from inbox", (Throwable)e);
            throw new ESBMailTransportIntegrationTestException("Error when deleting emails from inbox ", e);
        }
        finally {
            if (inbox != null) {
                try {
                    inbox.close(true);
                }
                catch (MessagingException e) {
                    log.warn((Object)"Error when closing the email folder : ", (Throwable)e);
                }
            }
            if (store != null) {
                try {
                    store.close();
                }
                catch (MessagingException e) {
                    log.warn((Object)"Error when closing the email store : ", (Throwable)e);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean searchStringInLog(String backendURL, String stringToFind, String cookie) throws ESBMailTransportIntegrationTestException {
        boolean expectedStringFound = false;
        long startTime = System.currentTimeMillis();
        try {
            while (System.currentTimeMillis() - startTime < (long)WAIT_TIME_MS) {
                LogEvent[] logs;
                LogViewerClient logViewerClient = new LogViewerClient(backendURL, cookie);
                for (LogEvent item : logs = logViewerClient.getAllRemoteSystemLogs()) {
                    String message = item.getMessage();
                    if (!message.contains(stringToFind)) continue;
                    log.info((Object)("Found the expected message in log : " + message));
                    return true;
                }
                if (expectedStringFound) {
                    return expectedStringFound;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    log.warn((Object)"Error while sleep the thread for 0.5 sec");
                }
            }
            return expectedStringFound;
        }
        catch (LogViewerLogViewerException e) {
            log.error((Object)"Error when reading the log to find a string ", (Throwable)e);
            throw new ESBMailTransportIntegrationTestException("Error when reading the log to find a string ", e);
        }
        catch (RemoteException e) {
            log.error((Object)"Error when getting the log ", (Throwable)e);
            throw new ESBMailTransportIntegrationTestException("Error when getting the log ", e);
        }
    }

    public static boolean waitToCheckEmailReceived(String subjectToCheck, String emailFolder) throws ESBMailTransportIntegrationTestException {
        boolean mailReceived = false;
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)WAIT_TIME_MS) {
            if (MailToTransportUtil.isMailReceivedBySubject(subjectToCheck, emailFolder)) {
                log.info((Object)("Found the expected email in mailbox : " + subjectToCheck));
                mailReceived = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                log.warn((Object)"Error while sleep the thread for 0.5 sec");
            }
        }
        return mailReceived;
    }

    public static void readXMLforEmailCredentials() throws ESBMailTransportIntegrationTestException {
        try {
            AutomationContext automationContext = new AutomationContext();
            automationContext.getConfigurationNodeList(EMAIL_CREDENTIAL_PARENT_XPATH);
            sender = automationContext.getConfigurationValue(EMAIL_CREDENTIAL_SENDER_XPATH);
            senderPassword = automationContext.getConfigurationValue(EMAIL_CREDENTIAL_SENDER_PASSWORD_XPATH).toCharArray();
            receiver = automationContext.getConfigurationValue(EMAIL_CREDENTIAL_RECEIVER_XPATH);
            receiverPassword = automationContext.getConfigurationValue(EMAIL_CREDENTIAL_RECEIVER_PASSWORD_XPATH).toCharArray();
            domain = automationContext.getConfigurationValue(EMAIL_CREDENTIAL_DOMAIN_XPATH);
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error when getting value from automation.xml ", (Throwable)e);
            throw new ESBMailTransportIntegrationTestException("Error when getting value from automation.xml ", e);
        }
    }

    static {
        WAIT_TIME_MS = 180000;
    }
}

