/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.spring.internal;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.env.ConfigurableEnvironment;
import org.wiremock.spring.ConfigureWireMock;
import org.wiremock.spring.WireMockConfigurationCustomizer;
import org.wiremock.spring.internal.Slf4jNotifier;
import org.wiremock.spring.internal.Store;
import org.wiremock.spring.internal.WireMockContextCustomizer;

public class WireMockServerCreator {
    private final Logger logger;

    public WireMockServerCreator(String name) {
        this.logger = LoggerFactory.getLogger((String)(WireMockServerCreator.class + " " + name));
    }

    public WireMockServer createWireMockServer(ConfigurableApplicationContext context, ConfigureWireMock options) {
        int serverPort = this.getServerProperty(context.getEnvironment(), options);
        WireMockConfiguration serverOptions = WireMockConfiguration.options().port(serverPort).notifier((Notifier)new Slf4jNotifier(options.name()));
        this.configureFilesUnderClasspath(options.filesUnderClasspath(), "/" + options.name()).ifPresentOrElse(present -> this.usingFilesUnderClasspath(serverOptions, (String)present), () -> this.configureFilesUnderClasspath(options.filesUnderClasspath(), "").ifPresentOrElse(present -> this.usingFilesUnderClasspath(serverOptions, (String)present), () -> this.configureFilesUnderDirectory(options.filesUnderDirectory(), "/" + options.name()).ifPresentOrElse(present -> this.usingFilesUnderDirectory(serverOptions, (String)present), () -> this.configureFilesUnderDirectory(options.filesUnderDirectory(), "").ifPresent(present -> this.usingFilesUnderDirectory(serverOptions, (String)present)))));
        if (options.extensions().length > 0) {
            serverOptions.extensions((Class[])options.extensions());
        }
        this.applyCustomizers(options, serverOptions);
        this.logger.info("Configuring WireMockServer with name '{}' on port: {}", (Object)options.name(), (Object)serverOptions.portNumber());
        WireMockServer newServer = new WireMockServer((Options)serverOptions);
        newServer.start();
        this.logger.info("Started WireMockServer with name '{}':{}", (Object)options.name(), (Object)newServer.baseUrl());
        Store.INSTANCE.store((ApplicationContext)context, options.name(), newServer);
        context.addApplicationListener(event -> {
            if (event instanceof ContextClosedEvent) {
                this.logger.info("Stopping WireMockServer with name '{}'", (Object)options.name());
                newServer.stop();
            }
        });
        Arrays.stream(options.baseUrlProperties()).filter(StringUtils::isNotBlank).collect(Collectors.toList()).forEach(propertyName -> {
            String property = propertyName + "=" + newServer.baseUrl();
            this.logger.info("Adding property '{}' to Spring application context", (Object)property);
            TestPropertyValues.of((String[])new String[]{property}).applyTo(context.getEnvironment());
        });
        Arrays.stream(options.portProperties()).filter(StringUtils::isNotBlank).collect(Collectors.toList()).forEach(propertyName -> {
            String property = propertyName + "=" + newServer.port();
            this.logger.info("Adding property '{}' to Spring application context", (Object)property);
            TestPropertyValues.of((String[])new String[]{property}).applyTo(context.getEnvironment());
        });
        return newServer;
    }

    private int getServerProperty(ConfigurableEnvironment environment, ConfigureWireMock options) {
        if (!options.usePortFromPredefinedPropertyIfFound()) {
            return options.port();
        }
        return Arrays.stream(options.portProperties()).filter(StringUtils::isNotBlank).filter(propertyName -> environment.containsProperty(propertyName)).map(propertyName -> {
            int predefinedPropertyValue = Integer.parseInt(environment.getProperty(propertyName));
            this.logger.info("Found predefined port in property with name '{}' on port: {}", propertyName, (Object)predefinedPropertyValue);
            return predefinedPropertyValue;
        }).findFirst().orElse(options.port());
    }

    private WireMockConfiguration usingFilesUnderClasspath(WireMockConfiguration serverOptions, String resource) {
        this.logger.info("Serving WireMock mappings from classpath resource: " + resource);
        return serverOptions.usingFilesUnderClasspath(resource);
    }

    private WireMockConfiguration usingFilesUnderDirectory(WireMockConfiguration serverOptions, String dir) {
        this.logger.info("Serving WireMock mappings from directory: " + dir);
        return serverOptions.usingFilesUnderDirectory(dir);
    }

    private Optional<String> configureFilesUnderClasspath(String[] filesUnderClasspath, String suffix) {
        List<String> alternatives = List.of(filesUnderClasspath).stream().map(it -> it + suffix).filter(it -> {
            String name = "/" + it;
            boolean exists = WireMockContextCustomizer.class.getResource(name) != null;
            this.logger.info("Looking for mocks in classpath " + name + "... " + (exists ? "found" : ""));
            return exists;
        }).toList();
        if (alternatives.size() > 1) {
            throw new IllegalStateException("Found several filesUnderClasspath: " + alternatives.stream().collect(Collectors.joining(", ")));
        }
        return alternatives.stream().findFirst();
    }

    private Optional<String> configureFilesUnderDirectory(String[] filesUnderDirectory, String suffix) {
        List<String> alternatives = List.of(filesUnderDirectory).stream().map(it -> it + suffix).filter(it -> {
            File name;
            boolean exists = (name = Path.of(it, new String[0]).toFile()).exists();
            this.logger.info("Looking for mocks in directory " + name + "... " + (exists ? "found" : ""));
            return exists;
        }).toList();
        String alternativesString = alternatives.stream().collect(Collectors.joining(", "));
        if (alternatives.size() > 1) {
            throw new IllegalStateException("Found several filesUnderDirectory: " + alternativesString);
        }
        this.logger.debug("Found " + alternativesString + " in " + Path.of("", new String[0]).toFile().getAbsolutePath());
        return alternatives.stream().findFirst();
    }

    @SuppressFBWarnings
    private void applyCustomizers(ConfigureWireMock options, WireMockConfiguration serverOptions) {
        for (Class<? extends WireMockConfigurationCustomizer> customizer : options.configurationCustomizers()) {
            try {
                ((WireMockConfigurationCustomizer)ReflectionUtils.newInstance(customizer, (Object[])new Object[0])).customize(serverOptions, options);
            }
            catch (Exception e) {
                if (e instanceof NoSuchMethodException) {
                    this.logger.error("Customizer {} must have a no-arg constructor", customizer, (Object)e);
                }
                throw e;
            }
        }
    }
}

