/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.custommonkey.xmlunit;

import java.util.Arrays;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import wiremock.org.custommonkey.xmlunit.ElementNameQualifier;
import wiremock.org.xmlunit.diff.ElementSelector;
import wiremock.org.xmlunit.diff.ElementSelectors;

public class ElementNameAndAttributeQualifier
extends ElementNameQualifier {
    private final ElementSelector selector;
    private static final String[] ALL_ATTRIBUTES = new String[]{"*"};
    private final String[] qualifyingAttrNames;

    public ElementNameAndAttributeQualifier() {
        this(ALL_ATTRIBUTES);
    }

    public ElementNameAndAttributeQualifier(String attrName) {
        this(new String[]{attrName});
    }

    public ElementNameAndAttributeQualifier(String[] attrNames) {
        this.qualifyingAttrNames = new String[attrNames.length];
        System.arraycopy(attrNames, 0, this.qualifyingAttrNames, 0, attrNames.length);
        this.selector = ElementNameAndAttributeQualifier.matchesAllAttributes(attrNames) ? ElementSelectors.byNameAndAllAttributes : ElementSelectors.byNameAndAttributesControlNS(attrNames);
    }

    @Override
    public boolean qualifyForComparison(Element control, Element test) {
        return this.selector.canBeCompared(control, test);
    }

    @Deprecated
    protected final boolean areAttributesComparable(Element control, Element test) {
        int n;
        Attr[] qualifyingAttributes;
        NamedNodeMap namedNodeMap = control.getAttributes();
        if (ElementNameAndAttributeQualifier.matchesAllAttributes(this.qualifyingAttrNames)) {
            qualifyingAttributes = new Attr[namedNodeMap.getLength()];
            for (n = 0; n < qualifyingAttributes.length; ++n) {
                qualifyingAttributes[n] = (Attr)namedNodeMap.item(n);
            }
        } else {
            qualifyingAttributes = new Attr[this.qualifyingAttrNames.length];
            for (n = 0; n < this.qualifyingAttrNames.length; ++n) {
                qualifyingAttributes[n] = (Attr)namedNodeMap.getNamedItem(this.qualifyingAttrNames[n]);
            }
        }
        for (int i2 = 0; i2 < qualifyingAttributes.length; ++i2) {
            String name;
            String controlValue;
            String nsURI;
            if (qualifyingAttributes[i2] != null) {
                nsURI = qualifyingAttributes[i2].getNamespaceURI();
                controlValue = qualifyingAttributes[i2].getNodeValue();
                name = qualifyingAttributes[i2].getName();
            } else {
                controlValue = "";
                nsURI = "";
                name = this.qualifyingAttrNames[i2];
            }
            String testValue = nsURI == null || nsURI.length() == 0 ? test.getAttribute(name) : test.getAttributeNS(nsURI, qualifyingAttributes[i2].getLocalName());
            if (!(controlValue == null ? testValue != null : !controlValue.equals(testValue))) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesAllAttributes(String[] attributes) {
        return Arrays.equals(attributes, ALL_ATTRIBUTES);
    }
}

