/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.core5.http2.protocol;

import java.io.IOException;
import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.http.EntityDetails;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpRequest;
import wiremock.org.apache.hc.core5.http.Method;
import wiremock.org.apache.hc.core5.http.ProtocolException;
import wiremock.org.apache.hc.core5.http.ProtocolVersion;
import wiremock.org.apache.hc.core5.http.message.MessageSupport;
import wiremock.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.org.apache.hc.core5.http.protocol.RequestContent;
import wiremock.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class H2RequestContent
extends RequestContent {
    public static final H2RequestContent INSTANCE = new H2RequestContent();

    public H2RequestContent() {
    }

    public H2RequestContent(boolean overwrite) {
        super(overwrite);
    }

    @Override
    public void process(HttpRequest request2, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(context, "HTTP context");
        ProtocolVersion ver = context.getProtocolVersion();
        if (ver.getMajor() < 2) {
            super.process(request2, entity, context);
        } else if (entity != null) {
            String method = request2.getMethod();
            if (Method.TRACE.isSame(method)) {
                throw new ProtocolException("TRACE request may not enclose an entity");
            }
            MessageSupport.addContentTypeHeader(request2, entity);
            MessageSupport.addContentEncodingHeader(request2, entity);
            MessageSupport.addTrailerHeader(request2, entity);
        }
    }
}

