/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.helper;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wiremock.com.github.jknack.handlebars.Handlebars;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.Options;
import wiremock.com.github.jknack.handlebars.helper.DefI18nSource;
import wiremock.com.github.jknack.handlebars.helper.I18nSource;
import wiremock.com.github.jknack.handlebars.internal.Locales;
import wiremock.com.github.jknack.handlebars.internal.lang3.StringUtils;
import wiremock.com.github.jknack.handlebars.internal.lang3.Validate;

public enum I18nHelper implements Helper<String>
{
    i18n{

        @Override
        public Object apply(String key, Options options2) throws IOException {
            Validate.notEmpty(key, "found: '%s', expected 'bundle's key'", key);
            Locale locale = Locales.fromString((String)options2.hash("locale", this.defaultLocale.toString()));
            String baseName = (String)options2.hash("bundle", this.defaultBundle);
            ClassLoader classLoader = (ClassLoader)options2.hash("classLoader", this.getClass().getClassLoader());
            I18nSource localSource = this.source == null ? new DefI18nSource(this.charset, baseName, locale, classLoader) : this.source;
            return localSource.message(key, locale, options2.params);
        }
    }
    ,
    i18nJs{
        private final Pattern pattern = Pattern.compile("\\{(\\d+)\\}");

        @Override
        public Object apply(String localeName, Options options2) throws IOException {
            String[] keys;
            Locale locale = Locales.fromString(StringUtils.defaultIfEmpty(localeName, this.defaultLocale.toString()));
            String baseName = (String)options2.hash("bundle", this.defaultBundle);
            ClassLoader classLoader = (ClassLoader)options2.hash("classLoader", this.getClass().getClassLoader());
            I18nSource localSource = this.source == null ? new DefI18nSource(this.charset, baseName, locale, classLoader) : this.source;
            StringBuilder buffer = new StringBuilder();
            Boolean wrap = (Boolean)options2.hash("wrap", true);
            if (wrap.booleanValue()) {
                buffer.append("<script type='text/javascript'>\n");
            }
            buffer.append("  /* ").append(locale.getDisplayName()).append(" */\n");
            buffer.append("  I18n.translations = I18n.translations || {};\n");
            buffer.append("  I18n.translations['").append(locale.toString()).append("'] = {\n");
            StringBuilder body2 = new StringBuilder();
            String separator = ",\n";
            for (String key : keys = localSource.keys(baseName, locale)) {
                String message = this.message(localSource.message(key, locale, new Object[0]));
                body2.append("    \"").append(key).append("\": ");
                body2.append("\"").append(message).append("\"").append(separator);
            }
            if (body2.length() > 0) {
                body2.setLength(body2.length() - separator.length());
                buffer.append((CharSequence)body2);
            }
            buffer.append("\n  };\n");
            if (wrap.booleanValue()) {
                buffer.append("</script>\n");
            }
            return new Handlebars.SafeString(buffer);
        }

        private String message(String message) {
            CharSequence escapedMessage = Handlebars.Utils.escapeExpression(message);
            Matcher matcher = this.pattern.matcher(escapedMessage);
            StringBuffer result = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(result, "{{arg" + matcher.group(1) + "}}");
            }
            matcher.appendTail(result);
            return result.toString();
        }
    };

    protected Locale defaultLocale = Locale.getDefault();
    protected String defaultBundle = "messages";
    protected I18nSource source;
    protected Charset charset = StandardCharsets.UTF_8;

    public void setCharset(Charset charset) {
        this.charset = Validate.notNull(charset, "Charset required.", new Object[0]);
    }

    public void setSource(I18nSource source) {
        this.source = Validate.notNull(source, "The i18n source is required.", new Object[0]);
    }

    public void setDefaultBundle(String bundle) {
        this.defaultBundle = Validate.notEmpty(bundle, "A bundle's name is required.", new Object[0]);
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = Validate.notNull(locale, "A locale is required.", new Object[0]);
    }
}

