/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.function;

import java.util.function.BiFunction;
import java.util.function.Function;

@FunctionalInterface
public interface ThrowingFunction<T, R>
extends Function<T, R> {
    public R applyWithException(T var1) throws Exception;

    @Override
    default public R apply(T t2) {
        return this.apply(t2, RuntimeException::new);
    }

    default public R apply(T t2, BiFunction<String, Exception, RuntimeException> exceptionWrapper) {
        try {
            return this.applyWithException(t2);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw exceptionWrapper.apply(ex.getMessage(), ex);
        }
    }

    default public ThrowingFunction<T, R> throwing(final BiFunction<String, Exception, RuntimeException> exceptionWrapper) {
        return new ThrowingFunction<T, R>(){

            @Override
            public R applyWithException(T t2) throws Exception {
                return ThrowingFunction.this.applyWithException(t2);
            }

            @Override
            public R apply(T t2) {
                return this.apply(t2, exceptionWrapper);
            }
        };
    }

    public static <T, R> ThrowingFunction<T, R> of(ThrowingFunction<T, R> function) {
        return function;
    }

    public static <T, R> ThrowingFunction<T, R> of(ThrowingFunction<T, R> function, BiFunction<String, Exception, RuntimeException> exceptionWrapper) {
        return function.throwing(exceptionWrapper);
    }
}

