/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.request;

import java.net.URI;
import org.springframework.http.HttpMethod;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMultipartHttpServletRequestBuilder;
import wiremock.jakarta.servlet.DispatcherType;

public abstract class MockMvcRequestBuilders {
    public static MockHttpServletRequestBuilder get(String urlTemplate, Object ... uriVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.GET, urlTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder get(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.GET, uri);
    }

    public static MockHttpServletRequestBuilder post(String urlTemplate, Object ... uriVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.POST, urlTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder post(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.POST, uri);
    }

    public static MockHttpServletRequestBuilder put(String urlTemplate, Object ... uriVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.PUT, urlTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder put(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.PUT, uri);
    }

    public static MockHttpServletRequestBuilder patch(String urlTemplate, Object ... uriVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.PATCH, urlTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder patch(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.PATCH, uri);
    }

    public static MockHttpServletRequestBuilder delete(String urlTemplate, Object ... uriVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.DELETE, urlTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder delete(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.DELETE, uri);
    }

    public static MockHttpServletRequestBuilder options(String urlTemplate, Object ... uriVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.OPTIONS, urlTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder options(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.OPTIONS, uri);
    }

    public static MockHttpServletRequestBuilder head(String urlTemplate, Object ... uriVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.HEAD, urlTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder head(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.HEAD, uri);
    }

    public static MockHttpServletRequestBuilder request(HttpMethod method, String urlTemplate, Object ... uriVariables) {
        return new MockHttpServletRequestBuilder(method, urlTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder request(HttpMethod httpMethod, URI uri) {
        return new MockHttpServletRequestBuilder(httpMethod, uri);
    }

    public static MockHttpServletRequestBuilder request(String httpMethod, URI uri) {
        return new MockHttpServletRequestBuilder(httpMethod, uri);
    }

    public static MockMultipartHttpServletRequestBuilder multipart(String urlTemplate, Object ... uriVariables) {
        return new MockMultipartHttpServletRequestBuilder(urlTemplate, uriVariables);
    }

    public static MockMultipartHttpServletRequestBuilder multipart(HttpMethod httpMethod, String urlTemplate, Object ... uriVariables) {
        return new MockMultipartHttpServletRequestBuilder(httpMethod, urlTemplate, uriVariables);
    }

    public static MockMultipartHttpServletRequestBuilder multipart(URI uri) {
        return new MockMultipartHttpServletRequestBuilder(uri);
    }

    public static MockMultipartHttpServletRequestBuilder multipart(HttpMethod httpMethod, URI uri) {
        return new MockMultipartHttpServletRequestBuilder(httpMethod, uri);
    }

    public static RequestBuilder asyncDispatch(MvcResult mvcResult) {
        mvcResult.getAsyncResult();
        return servletContext -> {
            MockHttpServletRequest request2 = mvcResult.getRequest();
            request2.setDispatcherType(DispatcherType.ASYNC);
            request2.setAsyncStarted(false);
            return request2;
        };
    }
}

