/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.htmlunit;

import com.gargoylesoftware.htmlunit.WebClient;
import org.springframework.lang.Nullable;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.htmlunit.MockMvcWebConnectionBuilderSupport;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

public class MockMvcWebClientBuilder
extends MockMvcWebConnectionBuilderSupport<MockMvcWebClientBuilder> {
    @Nullable
    private WebClient webClient;

    protected MockMvcWebClientBuilder(MockMvc mockMvc) {
        super(mockMvc);
    }

    protected MockMvcWebClientBuilder(WebApplicationContext context) {
        super(context);
    }

    protected MockMvcWebClientBuilder(WebApplicationContext context, MockMvcConfigurer configurer) {
        super(context, configurer);
    }

    public static MockMvcWebClientBuilder mockMvcSetup(MockMvc mockMvc) {
        Assert.notNull((Object)mockMvc, "MockMvc must not be null");
        return new MockMvcWebClientBuilder(mockMvc);
    }

    public static MockMvcWebClientBuilder webAppContextSetup(WebApplicationContext context) {
        Assert.notNull((Object)context, "WebApplicationContext must not be null");
        return new MockMvcWebClientBuilder(context);
    }

    public static MockMvcWebClientBuilder webAppContextSetup(WebApplicationContext context, MockMvcConfigurer configurer) {
        Assert.notNull((Object)context, "WebApplicationContext must not be null");
        Assert.notNull((Object)configurer, "MockMvcConfigurer must not be null");
        return new MockMvcWebClientBuilder(context, configurer);
    }

    public MockMvcWebClientBuilder withDelegate(WebClient webClient) {
        Assert.notNull((Object)webClient, "WebClient must not be null");
        webClient.setWebConnection(this.createConnection(webClient));
        this.webClient = webClient;
        return this;
    }

    public WebClient build() {
        return this.webClient != null ? this.webClient : this.withDelegate(new WebClient()).build();
    }
}

