/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.match.ContentRequestMatchers;
import org.springframework.test.web.client.match.JsonPathRequestMatchers;
import org.springframework.test.web.client.match.XpathRequestMatchers;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;
import wiremock.org.hamcrest.Matcher;
import wiremock.org.hamcrest.MatcherAssert;

public abstract class MockRestRequestMatchers {
    public static RequestMatcher anything() {
        return request2 -> {};
    }

    public static RequestMatcher method(HttpMethod method) {
        Assert.notNull((Object)method, "'method' must not be null");
        return request2 -> AssertionErrors.assertEquals("Unexpected HttpMethod", method, request2.getMethod());
    }

    public static RequestMatcher requestTo(Matcher<? super String> matcher) {
        Assert.notNull(matcher, "'matcher' must not be null");
        return request2 -> MatcherAssert.assertThat("Request URI", request2.getURI().toString(), matcher);
    }

    public static RequestMatcher requestTo(String expectedUri) {
        Assert.notNull((Object)expectedUri, "'uri' must not be null");
        return request2 -> AssertionErrors.assertEquals("Request URI", expectedUri, request2.getURI().toString());
    }

    public static RequestMatcher requestToUriTemplate(String expectedUri, Object ... uriVars) {
        Assert.notNull((Object)expectedUri, "'uri' must not be null");
        URI uri = UriComponentsBuilder.fromUriString((String)expectedUri).buildAndExpand(uriVars).encode().toUri();
        return MockRestRequestMatchers.requestTo(uri);
    }

    public static RequestMatcher requestTo(URI uri) {
        Assert.notNull((Object)uri, "'uri' must not be null");
        return request2 -> AssertionErrors.assertEquals("Unexpected request", uri, request2.getURI());
    }

    public static RequestMatcher queryParamList(String name, Matcher<? super List<String>> matcher) {
        return request2 -> {
            MultiValueMap<String, String> params = MockRestRequestMatchers.getQueryParams(request2);
            List paramValues = (List)params.get(name);
            if (paramValues == null) {
                AssertionErrors.fail("Expected query param <" + name + "> to exist but was null");
            }
            MatcherAssert.assertThat("Query param [" + name + "] values", paramValues, matcher);
        };
    }

    @SafeVarargs
    public static RequestMatcher queryParam(String name, Matcher<? super String> ... matchers) {
        return request2 -> {
            MultiValueMap<String, String> params = MockRestRequestMatchers.getQueryParams(request2);
            MockRestRequestMatchers.assertValueCount("query param", name, params, matchers.length);
            for (int i2 = 0; i2 < matchers.length; ++i2) {
                MatcherAssert.assertThat("Query param", (String)((List)params.get(name)).get(i2), matchers[i2]);
            }
        };
    }

    public static RequestMatcher queryParam(String name, String ... expectedValues) {
        return request2 -> {
            MultiValueMap<String, String> params = MockRestRequestMatchers.getQueryParams(request2);
            MockRestRequestMatchers.assertValueCount("query param", name, params, expectedValues.length);
            for (int i2 = 0; i2 < expectedValues.length; ++i2) {
                AssertionErrors.assertEquals("Query param [" + name + "]", expectedValues[i2], ((List)params.get(name)).get(i2));
            }
        };
    }

    private static MultiValueMap<String, String> getQueryParams(ClientHttpRequest request2) {
        return UriComponentsBuilder.fromUri((URI)request2.getURI()).build().getQueryParams();
    }

    public static RequestMatcher headerList(String name, Matcher<? super List<String>> matcher) {
        return request2 -> {
            List headerValues = request2.getHeaders().get((Object)name);
            if (headerValues == null) {
                AssertionErrors.fail("Expected header <" + name + "> to exist but was null");
            }
            MatcherAssert.assertThat("Request header [" + name + "] values", headerValues, matcher);
        };
    }

    @SafeVarargs
    public static RequestMatcher header(String name, Matcher<? super String> ... matchers) {
        return request2 -> {
            MockRestRequestMatchers.assertValueCount("header", name, (MultiValueMap<String, String>)request2.getHeaders(), matchers.length);
            List headerValues = request2.getHeaders().get((Object)name);
            Assert.state(headerValues != null, "No header values");
            for (int i2 = 0; i2 < matchers.length; ++i2) {
                MatcherAssert.assertThat("Request header [" + name + "]", (String)headerValues.get(i2), matchers[i2]);
            }
        };
    }

    public static RequestMatcher header(String name, String ... expectedValues) {
        return request2 -> {
            MockRestRequestMatchers.assertValueCount("header", name, (MultiValueMap<String, String>)request2.getHeaders(), expectedValues.length);
            List headerValues = request2.getHeaders().get((Object)name);
            Assert.state(headerValues != null, "No header values");
            for (int i2 = 0; i2 < expectedValues.length; ++i2) {
                AssertionErrors.assertEquals("Request header [" + name + "]", expectedValues[i2], headerValues.get(i2));
            }
        };
    }

    public static RequestMatcher headerDoesNotExist(String name) {
        return request2 -> {
            List headerValues = request2.getHeaders().get((Object)name);
            if (headerValues != null) {
                AssertionErrors.fail("Expected header <" + name + "> not to exist, but it exists with values: " + headerValues);
            }
        };
    }

    public static ContentRequestMatchers content() {
        return new ContentRequestMatchers();
    }

    public static JsonPathRequestMatchers jsonPath(String expression, Object ... args) {
        return new JsonPathRequestMatchers(expression, args);
    }

    public static <T> RequestMatcher jsonPath(String expression, Matcher<? super T> matcher) {
        return new JsonPathRequestMatchers(expression, new Object[0]).value(matcher);
    }

    public static XpathRequestMatchers xpath(String expression, Object ... args) throws XPathExpressionException {
        return new XpathRequestMatchers(expression, null, args);
    }

    public static XpathRequestMatchers xpath(String expression, Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        return new XpathRequestMatchers(expression, namespaces, args);
    }

    private static void assertValueCount(String valueType, String name, MultiValueMap<String, String> map, int count) {
        List values = (List)map.get(name);
        String message = "Expected " + valueType + " <" + name + ">";
        if (values == null) {
            AssertionErrors.fail(message + " to exist but was null");
        }
        if (count > values.size()) {
            AssertionErrors.fail(message + " to have at least <" + count + "> values but found " + values);
        }
    }
}

