/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import org.springframework.util.Assert;

public final class ExpectedCount {
    private final int minCount;
    private final int maxCount;

    private ExpectedCount(int minCount, int maxCount) {
        Assert.isTrue(minCount >= 0, "minCount >= 0 is required");
        Assert.isTrue(maxCount >= minCount, "maxCount >= minCount is required");
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public static ExpectedCount once() {
        return new ExpectedCount(1, 1);
    }

    public static ExpectedCount twice() {
        return new ExpectedCount(2, 2);
    }

    public static ExpectedCount manyTimes() {
        return new ExpectedCount(1, Integer.MAX_VALUE);
    }

    public static ExpectedCount times(int count) {
        Assert.isTrue(count >= 1, "'count' must be >= 1");
        return new ExpectedCount(count, count);
    }

    public static ExpectedCount min(int min2) {
        Assert.isTrue(min2 >= 1, "'min' must be >= 1");
        return new ExpectedCount(min2, Integer.MAX_VALUE);
    }

    public static ExpectedCount max(int max) {
        Assert.isTrue(max >= 1, "'max' must be >= 1");
        return new ExpectedCount(1, max);
    }

    public static ExpectedCount never() {
        return new ExpectedCount(0, 0);
    }

    public static ExpectedCount between(int min2, int max) {
        return new ExpectedCount(min2, max);
    }
}

