/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Random;
import javax.net.ServerSocketFactory;
import org.springframework.util.Assert;

public class TestSocketUtils {
    static final int PORT_RANGE_MIN = 1024;
    static final int PORT_RANGE_MAX = 65535;
    private static final int PORT_RANGE_PLUS_ONE = 64512;
    private static final int MAX_ATTEMPTS = 1000;
    private static final Random random = new Random(System.nanoTime());
    private static final TestSocketUtils INSTANCE = new TestSocketUtils();

    public static int findAvailableTcpPort() {
        return INSTANCE.findAvailableTcpPortInternal();
    }

    int findAvailableTcpPortInternal() {
        int candidatePort;
        int searchCounter = 0;
        do {
            Assert.state(++searchCounter <= 1000, () -> String.format("Could not find an available TCP port in the range [%d, %d] after %d attempts", 1024, 65535, 1000));
        } while (!this.isPortAvailable(candidatePort = 1024 + random.nextInt(64512)));
        return candidatePort;
    }

    boolean isPortAvailable(int port) {
        try {
            ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
            serverSocket.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

