/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.transaction;

import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.lang.Nullable;
import org.springframework.test.context.TestContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.util.Assert;
import wiremock.org.apache.commons.logging.Log;
import wiremock.org.apache.commons.logging.LogFactory;

class TransactionContext {
    private static final Log logger = LogFactory.getLog(TransactionContext.class);
    private final TestContext testContext;
    private final TransactionDefinition transactionDefinition;
    private final PlatformTransactionManager transactionManager;
    private final boolean defaultRollback;
    private boolean flaggedForRollback;
    @Nullable
    private TransactionStatus transactionStatus;
    private final AtomicInteger transactionsStarted = new AtomicInteger();

    TransactionContext(TestContext testContext, PlatformTransactionManager transactionManager, TransactionDefinition transactionDefinition, boolean defaultRollback) {
        this.testContext = testContext;
        this.transactionManager = transactionManager;
        this.transactionDefinition = transactionDefinition;
        this.defaultRollback = defaultRollback;
        this.flaggedForRollback = defaultRollback;
    }

    @Nullable
    TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    boolean isFlaggedForRollback() {
        return this.flaggedForRollback;
    }

    void setFlaggedForRollback(boolean flaggedForRollback) {
        Assert.state(this.transactionStatus != null, () -> "Failed to set rollback flag - transaction does not exist: " + this.testContext);
        this.flaggedForRollback = flaggedForRollback;
    }

    void startTransaction() {
        Assert.state(this.transactionStatus == null, "Cannot start a new transaction without ending the existing transaction first");
        this.flaggedForRollback = this.defaultRollback;
        this.transactionStatus = this.transactionManager.getTransaction(this.transactionDefinition);
        int transactionsStarted = this.transactionsStarted.incrementAndGet();
        if (logger.isTraceEnabled()) {
            logger.trace("Began transaction (%d) for test context %s; transaction manager [%s]; rollback [%s]".formatted(transactionsStarted, this.testContext, this.transactionManager, this.flaggedForRollback));
        } else if (logger.isDebugEnabled()) {
            logger.debug("Began transaction (%d) for test class [%s]; test method [%s]; transaction manager [%s]; rollback [%s]".formatted(transactionsStarted, this.testContext.getTestClass().getName(), this.testContext.getTestMethod().getName(), this.transactionManager, this.flaggedForRollback));
        }
    }

    void endTransaction() {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Ending transaction for test context %s; transaction status [%s]; rollback [%s]", this.testContext, this.transactionStatus, this.flaggedForRollback));
        }
        Assert.state(this.transactionStatus != null, () -> "Failed to end transaction - transaction does not exist: " + this.testContext);
        try {
            if (this.flaggedForRollback) {
                this.transactionManager.rollback(this.transactionStatus);
            } else {
                this.transactionManager.commit(this.transactionStatus);
            }
        }
        finally {
            this.transactionStatus = null;
        }
        int transactionsStarted = this.transactionsStarted.get();
        if (logger.isTraceEnabled()) {
            logger.trace("%s transaction (%d) for test context: %s".formatted(this.flaggedForRollback ? "Rolled back" : "Committed", transactionsStarted, this.testContext));
        } else if (logger.isDebugEnabled()) {
            logger.debug("%s transaction (%d) for test class [%s]; test method [%s]".formatted(this.flaggedForRollback ? "Rolled back" : "Committed", transactionsStarted, this.testContext.getTestClass().getName(), this.testContext.getTestMethod().getName()));
        }
    }
}

