/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.testng;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.lang.Nullable;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.springframework.test.jdbc.JdbcTestUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional
public abstract class AbstractTransactionalTestNGSpringContextTests
extends AbstractTestNGSpringContextTests {
    protected final JdbcTemplate jdbcTemplate = new JdbcTemplate();
    @Nullable
    private String sqlScriptEncoding;

    @Autowired
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate.setDataSource(dataSource);
    }

    public void setSqlScriptEncoding(String sqlScriptEncoding) {
        this.sqlScriptEncoding = sqlScriptEncoding;
    }

    protected int countRowsInTable(String tableName) {
        return JdbcTestUtils.countRowsInTable((JdbcOperations)this.jdbcTemplate, tableName);
    }

    protected int countRowsInTableWhere(String tableName, String whereClause) {
        return JdbcTestUtils.countRowsInTableWhere((JdbcOperations)this.jdbcTemplate, tableName, whereClause);
    }

    protected int deleteFromTables(String ... names) {
        return JdbcTestUtils.deleteFromTables((JdbcOperations)this.jdbcTemplate, names);
    }

    protected int deleteFromTableWhere(String tableName, String whereClause, Object ... args) {
        return JdbcTestUtils.deleteFromTableWhere((JdbcOperations)this.jdbcTemplate, tableName, whereClause, args);
    }

    protected void dropTables(String ... names) {
        JdbcTestUtils.dropTables((JdbcOperations)this.jdbcTemplate, names);
    }

    protected void executeSqlScript(String sqlResourcePath, boolean continueOnError) throws DataAccessException {
        DataSource ds = this.jdbcTemplate.getDataSource();
        Assert.state(ds != null, "No DataSource set");
        Assert.state(this.applicationContext != null, "No ApplicationContext available");
        Resource resource = this.applicationContext.getResource(sqlResourcePath);
        new ResourceDatabasePopulator(continueOnError, false, this.sqlScriptEncoding, new Resource[]{resource}).execute(ds);
    }
}

