/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.Arrays;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractGenericContextLoader;

public class GenericXmlContextLoader
extends AbstractGenericContextLoader {
    @Override
    protected BeanDefinitionReader createBeanDefinitionReader(GenericApplicationContext context) {
        return new XmlBeanDefinitionReader(context);
    }

    @Override
    protected String getResourceSuffix() {
        return "-context.xml";
    }

    @Override
    protected void validateMergedContextConfiguration(MergedContextConfiguration mergedConfig) {
        if (mergedConfig.hasClasses()) {
            String msg = "Test class [%s] has been configured with @ContextConfiguration's 'classes' attribute %s, but %s does not support annotated classes.".formatted(mergedConfig.getTestClass().getName(), Arrays.toString(mergedConfig.getClasses()), this.getClass().getSimpleName());
            logger.error(msg);
            throw new IllegalStateException(msg);
        }
    }
}

