/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.util.Assert;
import wiremock.org.apache.commons.logging.Log;
import wiremock.org.apache.commons.logging.LogFactory;

abstract class ApplicationContextInitializerUtils {
    private static final Log logger = LogFactory.getLog(ApplicationContextInitializerUtils.class);

    ApplicationContextInitializerUtils() {
    }

    static Set<Class<? extends ApplicationContextInitializer<?>>> resolveInitializerClasses(List<ContextConfigurationAttributes> configAttributesList) {
        Assert.notEmpty(configAttributesList, "ContextConfigurationAttributes List must not be empty");
        LinkedHashSet initializerClasses = new LinkedHashSet();
        for (ContextConfigurationAttributes configAttributes : configAttributesList) {
            if (logger.isTraceEnabled()) {
                logger.trace("Processing context initializers for configuration attributes " + configAttributes);
            }
            Collections.addAll(initializerClasses, configAttributes.getInitializers());
            if (configAttributes.isInheritInitializers()) continue;
            break;
        }
        return initializerClasses;
    }
}

