/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4.rules;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.junit4.statements.ProfileValueChecker;
import org.springframework.test.context.junit4.statements.RunAfterTestClassCallbacks;
import org.springframework.test.context.junit4.statements.RunBeforeTestClassCallbacks;
import org.springframework.util.Assert;
import wiremock.org.apache.commons.logging.Log;
import wiremock.org.apache.commons.logging.LogFactory;

public class SpringClassRule
implements TestRule {
    private static final Log logger = LogFactory.getLog(SpringClassRule.class);
    private static final Map<Class<?>, TestContextManager> testContextManagerCache = new ConcurrentHashMap(64);

    public Statement apply(Statement base, Description description) {
        Class testClass = description.getTestClass();
        if (logger.isDebugEnabled()) {
            logger.debug("Applying SpringClassRule to test class [" + testClass.getName() + "]");
        }
        TestContextManager testContextManager = SpringClassRule.getTestContextManager(testClass);
        Statement statement = base;
        statement = this.withBeforeTestClassCallbacks(statement, testContextManager);
        statement = this.withAfterTestClassCallbacks(statement, testContextManager);
        statement = this.withProfileValueCheck(statement, testClass);
        statement = this.withTestContextManagerCacheEviction(statement, testClass);
        return statement;
    }

    private Statement withBeforeTestClassCallbacks(Statement next, TestContextManager testContextManager) {
        return new RunBeforeTestClassCallbacks(next, testContextManager);
    }

    private Statement withAfterTestClassCallbacks(Statement next, TestContextManager testContextManager) {
        return new RunAfterTestClassCallbacks(next, testContextManager);
    }

    private Statement withProfileValueCheck(Statement next, Class<?> testClass) {
        return new ProfileValueChecker(next, testClass, null);
    }

    private Statement withTestContextManagerCacheEviction(Statement next, Class<?> testClass) {
        return new TestContextManagerCacheEvictor(next, testClass);
    }

    static TestContextManager getTestContextManager(Class<?> testClass) {
        Assert.notNull(testClass, "Test Class must not be null");
        return testContextManagerCache.computeIfAbsent(testClass, TestContextManager::new);
    }

    private static class TestContextManagerCacheEvictor
    extends Statement {
        private final Statement next;
        private final Class<?> testClass;

        TestContextManagerCacheEvictor(Statement next, Class<?> testClass) {
            this.next = next;
            this.testClass = testClass;
        }

        public void evaluate() throws Throwable {
            try {
                this.next.evaluate();
            }
            finally {
                testContextManagerCache.remove(this.testClass);
            }
        }
    }
}

