/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.cache;

import java.util.List;
import org.springframework.aot.AotDetector;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ApplicationContextFailureProcessor;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.ContextLoadException;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.test.context.aot.AotContextLoader;
import org.springframework.test.context.aot.AotTestContextInitializers;
import org.springframework.test.context.aot.TestContextAotException;
import org.springframework.test.context.cache.AotMergedContextConfiguration;
import org.springframework.test.context.cache.ContextCache;
import org.springframework.test.context.cache.ContextCacheUtils;
import org.springframework.test.context.cache.DefaultContextCache;
import org.springframework.test.context.util.TestContextSpringFactoriesUtils;
import org.springframework.util.Assert;
import wiremock.org.apache.commons.logging.Log;
import wiremock.org.apache.commons.logging.LogFactory;

public class DefaultCacheAwareContextLoaderDelegate
implements CacheAwareContextLoaderDelegate {
    private static final Log logger = LogFactory.getLog(DefaultCacheAwareContextLoaderDelegate.class);
    static final ContextCache defaultContextCache = new DefaultContextCache();
    private final List<ApplicationContextFailureProcessor> contextFailureProcessors = TestContextSpringFactoriesUtils.loadFactoryImplementations(ApplicationContextFailureProcessor.class);
    private final AotTestContextInitializers aotTestContextInitializers = new AotTestContextInitializers();
    private final ContextCache contextCache;
    private final int failureThreshold;

    public DefaultCacheAwareContextLoaderDelegate() {
        this(defaultContextCache);
    }

    public DefaultCacheAwareContextLoaderDelegate(ContextCache contextCache) {
        this(contextCache, ContextCacheUtils.retrieveContextFailureThreshold());
    }

    private DefaultCacheAwareContextLoaderDelegate(ContextCache contextCache, int failureThreshold) {
        Assert.notNull((Object)contextCache, "ContextCache must not be null");
        Assert.isTrue(failureThreshold > 0, "'failureThreshold' must be positive");
        this.contextCache = contextCache;
        this.failureThreshold = failureThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isContextLoaded(MergedContextConfiguration mergedConfig) {
        mergedConfig = this.replaceIfNecessary(mergedConfig);
        ContextCache contextCache = this.contextCache;
        synchronized (contextCache) {
            return this.contextCache.contains(mergedConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationContext loadContext(MergedContextConfiguration mergedConfig) {
        mergedConfig = this.replaceIfNecessary(mergedConfig);
        ContextCache contextCache = this.contextCache;
        synchronized (contextCache) {
            ApplicationContext context;
            block19: {
                context = this.contextCache.get(mergedConfig);
                try {
                    if (context == null) {
                        int failureCount = this.contextCache.getFailureCount(mergedConfig);
                        if (failureCount >= this.failureThreshold) {
                            throw new IllegalStateException("ApplicationContext failure threshold (%d) exceeded: skipping repeated attempt to load context for %s".formatted(this.failureThreshold, mergedConfig));
                        }
                        try {
                            if (mergedConfig instanceof AotMergedContextConfiguration) {
                                AotMergedContextConfiguration aotMergedConfig = (AotMergedContextConfiguration)mergedConfig;
                                context = this.loadContextInAotMode(aotMergedConfig);
                            } else {
                                context = this.loadContextInternal(mergedConfig);
                            }
                            if (logger.isTraceEnabled()) {
                                logger.trace("Storing ApplicationContext [%s] in cache under key %s".formatted(System.identityHashCode(context), mergedConfig));
                            }
                            this.contextCache.put(mergedConfig, context);
                            break block19;
                        }
                        catch (Exception ex) {
                            if (logger.isTraceEnabled()) {
                                logger.trace("Incrementing ApplicationContext failure count for " + mergedConfig);
                            }
                            this.contextCache.incrementFailureCount(mergedConfig);
                            Throwable cause = ex;
                            if (ex instanceof ContextLoadException) {
                                ContextLoadException cle = (ContextLoadException)ex;
                                cause = cle.getCause();
                                for (ApplicationContextFailureProcessor contextFailureProcessor : this.contextFailureProcessors) {
                                    try {
                                        contextFailureProcessor.processLoadFailure(cle.getApplicationContext(), cause);
                                    }
                                    catch (Throwable throwable) {
                                        if (!logger.isDebugEnabled()) continue;
                                        logger.debug("Ignoring exception thrown from ApplicationContextFailureProcessor [%s]: %s".formatted(contextFailureProcessor, throwable));
                                    }
                                }
                            }
                            throw new IllegalStateException("Failed to load ApplicationContext for " + mergedConfig, cause);
                        }
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("Retrieved ApplicationContext [%s] from cache with key %s".formatted(System.identityHashCode(context), mergedConfig));
                    }
                }
                finally {
                    this.contextCache.logStatistics();
                }
            }
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeContext(MergedContextConfiguration mergedConfig, @Nullable DirtiesContext.HierarchyMode hierarchyMode) {
        mergedConfig = this.replaceIfNecessary(mergedConfig);
        ContextCache contextCache = this.contextCache;
        synchronized (contextCache) {
            this.contextCache.remove(mergedConfig, hierarchyMode);
        }
    }

    protected ContextCache getContextCache() {
        return this.contextCache;
    }

    protected ApplicationContext loadContextInternal(MergedContextConfiguration mergedConfig) throws Exception {
        ContextLoader contextLoader = this.getContextLoader(mergedConfig);
        if (contextLoader instanceof SmartContextLoader) {
            SmartContextLoader smartContextLoader = (SmartContextLoader)contextLoader;
            return smartContextLoader.loadContext(mergedConfig);
        }
        String[] locations = mergedConfig.getLocations();
        Assert.notNull((Object)locations, () -> "Cannot load an ApplicationContext with a NULL 'locations' array. Consider annotating test class [%s] with @ContextConfiguration or @ContextHierarchy.".formatted(mergedConfig.getTestClass().getName()));
        return contextLoader.loadContext(locations);
    }

    protected ApplicationContext loadContextInAotMode(AotMergedContextConfiguration aotMergedConfig) throws Exception {
        AotContextLoader aotContextLoader;
        ApplicationContext applicationContext;
        Class<?> testClass = aotMergedConfig.getTestClass();
        ApplicationContextInitializer<ConfigurableApplicationContext> contextInitializer = this.aotTestContextInitializers.getContextInitializer(testClass);
        Assert.state(contextInitializer != null, () -> "Failed to load AOT ApplicationContextInitializer for test class [%s]".formatted(testClass.getName()));
        ContextLoader contextLoader = this.getContextLoader(aotMergedConfig);
        if (logger.isTraceEnabled()) {
            logger.trace("Loading ApplicationContext for AOT runtime for " + aotMergedConfig.getOriginal());
        } else if (logger.isDebugEnabled()) {
            logger.debug("Loading ApplicationContext for AOT runtime for test class " + aotMergedConfig.getTestClass().getName());
        }
        if (!(contextLoader instanceof AotContextLoader) || !((applicationContext = (aotContextLoader = (AotContextLoader)contextLoader).loadContextForAotRuntime(aotMergedConfig.getOriginal(), contextInitializer)) instanceof GenericApplicationContext)) {
            throw new TestContextAotException("Cannot load ApplicationContext for AOT runtime for %s. The configured ContextLoader [%s] must be an AotContextLoader and must create a GenericApplicationContext.".formatted(aotMergedConfig.getOriginal(), contextLoader.getClass().getName()));
        }
        GenericApplicationContext gac = (GenericApplicationContext)applicationContext;
        gac.registerShutdownHook();
        return gac;
    }

    private ContextLoader getContextLoader(MergedContextConfiguration mergedConfig) {
        ContextLoader contextLoader = mergedConfig.getContextLoader();
        Assert.notNull((Object)contextLoader, () -> "Cannot load an ApplicationContext with a NULL 'contextLoader'. Consider annotating test class [%s] with @ContextConfiguration or @ContextHierarchy.".formatted(mergedConfig.getTestClass().getName()));
        return contextLoader;
    }

    private MergedContextConfiguration replaceIfNecessary(MergedContextConfiguration mergedConfig) {
        if (AotDetector.useGeneratedArtifacts()) {
            Class<?> testClass = mergedConfig.getTestClass();
            Class<ApplicationContextInitializer<?>> contextInitializerClass = this.aotTestContextInitializers.getContextInitializerClass(testClass);
            Assert.state(contextInitializerClass != null, () -> "Failed to load AOT ApplicationContextInitializer class for test class [%s]. This can occur if AOT processing has not taken place for the test suite. It can also occur if AOT processing failed for the test class, in which case you can consult the logs generated during AOT processing.".formatted(testClass.getName()));
            return new AotMergedContextConfiguration(testClass, contextInitializerClass, mergedConfig, this);
        }
        return mergedConfig;
    }
}

