/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.aot;

import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.aot.generate.FileSystemGeneratedFiles;
import org.springframework.context.aot.AbstractAotProcessor;
import org.springframework.test.context.aot.TestClassScanner;
import org.springframework.test.context.aot.TestContextAotGenerator;

public abstract class TestAotProcessor
extends AbstractAotProcessor<Void> {
    private final Set<Path> classpathRoots;

    protected TestAotProcessor(Set<Path> classpathRoots, AbstractAotProcessor.Settings settings) {
        super(settings);
        this.classpathRoots = classpathRoots;
    }

    protected Set<Path> getClasspathRoots() {
        return this.classpathRoots;
    }

    @Override
    protected Void doProcess() {
        this.deleteExistingOutput();
        this.performAotProcessing();
        return null;
    }

    protected void performAotProcessing() {
        Stream<Class<?>> testClasses = this.scanClasspathRoots();
        FileSystemGeneratedFiles generatedFiles = this.createFileSystemGeneratedFiles();
        TestContextAotGenerator generator = new TestContextAotGenerator(generatedFiles);
        generator.processAheadOfTime(testClasses);
        this.writeHints(generator.getRuntimeHints());
    }

    protected Stream<Class<?>> scanClasspathRoots() {
        TestClassScanner scanner = new TestClassScanner(this.getClasspathRoots());
        return scanner.scan();
    }
}

