/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.util.Arrays;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.style.DefaultToStringStyler;
import org.springframework.core.style.SimpleValueStyler;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextLoader;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import wiremock.org.apache.commons.logging.Log;
import wiremock.org.apache.commons.logging.LogFactory;

public class ContextConfigurationAttributes {
    private static final String[] EMPTY_LOCATIONS = new String[0];
    private static final Class<?>[] EMPTY_CLASSES = new Class[0];
    private static final Log logger = LogFactory.getLog(ContextConfigurationAttributes.class);
    private final Class<?> declaringClass;
    private Class<?>[] classes = new Class[0];
    private String[] locations = new String[0];
    private final boolean inheritLocations;
    private final Class<? extends ApplicationContextInitializer<?>>[] initializers;
    private final boolean inheritInitializers;
    @Nullable
    private final String name;
    private final Class<? extends ContextLoader> contextLoaderClass;

    public ContextConfigurationAttributes(Class<?> declaringClass) {
        this(declaringClass, EMPTY_LOCATIONS, EMPTY_CLASSES, false, EMPTY_CLASSES, true, ContextLoader.class);
    }

    public ContextConfigurationAttributes(Class<?> declaringClass, ContextConfiguration contextConfiguration) {
        this(declaringClass, contextConfiguration.locations(), contextConfiguration.classes(), contextConfiguration.inheritLocations(), contextConfiguration.initializers(), contextConfiguration.inheritInitializers(), contextConfiguration.name(), contextConfiguration.loader());
    }

    public ContextConfigurationAttributes(Class<?> declaringClass, AnnotationAttributes annAttrs) {
        this(declaringClass, annAttrs.getStringArray("locations"), annAttrs.getClassArray("classes"), annAttrs.getBoolean("inheritLocations"), annAttrs.getClassArray("initializers"), annAttrs.getBoolean("inheritInitializers"), annAttrs.getString("name"), annAttrs.getClass("loader"));
    }

    public ContextConfigurationAttributes(Class<?> declaringClass, String[] locations, Class<?>[] classes, boolean inheritLocations, Class<? extends ApplicationContextInitializer<?>>[] initializers, boolean inheritInitializers, Class<? extends ContextLoader> contextLoaderClass) {
        this(declaringClass, locations, classes, inheritLocations, initializers, inheritInitializers, null, contextLoaderClass);
    }

    public ContextConfigurationAttributes(Class<?> declaringClass, String[] locations, Class<?>[] classes, boolean inheritLocations, Class<? extends ApplicationContextInitializer<?>>[] initializers, boolean inheritInitializers, @Nullable String name, Class<? extends ContextLoader> contextLoaderClass) {
        Assert.notNull(declaringClass, "'declaringClass' must not be null");
        Assert.notNull(contextLoaderClass, "'contextLoaderClass' must not be null");
        if (!ObjectUtils.isEmpty(locations) && !ObjectUtils.isEmpty(classes) && logger.isDebugEnabled()) {
            logger.debug(String.format("Test class [%s] has been configured with @ContextConfiguration's 'locations' (or 'value') %s and 'classes' %s attributes. Most SmartContextLoader implementations support only one declaration of resources per @ContextConfiguration annotation.", declaringClass.getName(), ObjectUtils.nullSafeToString(locations), ObjectUtils.nullSafeToString(classes)));
        }
        this.declaringClass = declaringClass;
        this.locations = locations;
        this.classes = classes;
        this.inheritLocations = inheritLocations;
        this.initializers = initializers;
        this.inheritInitializers = inheritInitializers;
        this.name = StringUtils.hasText(name) ? name : null;
        this.contextLoaderClass = contextLoaderClass;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public void setClasses(Class<?> ... classes) {
        this.classes = classes;
    }

    public Class<?>[] getClasses() {
        return this.classes;
    }

    public boolean hasClasses() {
        return this.getClasses().length > 0;
    }

    public void setLocations(String ... locations) {
        this.locations = locations;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public boolean hasLocations() {
        return this.getLocations().length > 0;
    }

    public boolean hasResources() {
        return this.hasLocations() || this.hasClasses();
    }

    public boolean isInheritLocations() {
        return this.inheritLocations;
    }

    public Class<? extends ApplicationContextInitializer<?>>[] getInitializers() {
        return this.initializers;
    }

    public boolean isInheritInitializers() {
        return this.inheritInitializers;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public Class<? extends ContextLoader> getContextLoaderClass() {
        return this.contextLoaderClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof ContextConfigurationAttributes)) return false;
        ContextConfigurationAttributes that = (ContextConfigurationAttributes)other;
        if (!ObjectUtils.nullSafeEquals(this.declaringClass, that.declaringClass)) return false;
        if (!Arrays.equals(this.classes, that.classes)) return false;
        if (!Arrays.equals(this.locations, that.locations)) return false;
        if (this.inheritLocations != that.inheritLocations) return false;
        if (!Arrays.equals(this.initializers, that.initializers)) return false;
        if (this.inheritInitializers != that.inheritInitializers) return false;
        if (!ObjectUtils.nullSafeEquals(this.name, that.name)) return false;
        if (!ObjectUtils.nullSafeEquals(this.contextLoaderClass, that.contextLoaderClass)) return false;
        return true;
    }

    public int hashCode() {
        int result = this.declaringClass.hashCode();
        result = 31 * result + Arrays.hashCode(this.classes);
        result = 31 * result + Arrays.hashCode(this.locations);
        result = 31 * result + Arrays.hashCode(this.initializers);
        return result;
    }

    public String toString() {
        return new ToStringCreator((Object)this, new DefaultToStringStyler(new SimpleValueStyler())).append("declaringClass", this.declaringClass).append("classes", this.classes).append("locations", this.locations).append("inheritLocations", this.inheritLocations).append("initializers", this.initializers).append("inheritInitializers", this.inheritInitializers).append("name", this.name).append("contextLoaderClass", this.contextLoaderClass).toString();
    }
}

