/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.jetty;

import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.util.Assert;
import wiremock.jakarta.servlet.ServletException;
import wiremock.org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import wiremock.org.eclipse.jetty.ee10.webapp.WebAppContext;

public class ServletContextInitializerConfiguration
extends AbstractConfiguration {
    private final ServletContextInitializer[] initializers;

    public ServletContextInitializerConfiguration(ServletContextInitializer ... initializers) {
        super(new AbstractConfiguration.Builder());
        Assert.notNull((Object)initializers, "Initializers must not be null");
        this.initializers = initializers;
    }

    public void configure(WebAppContext context) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(context.getClassLoader());
        try {
            this.callInitializers(context);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callInitializers(WebAppContext context) throws ServletException {
        try {
            context.getContext().setExtendedListenerTypes(true);
            for (ServletContextInitializer initializer : this.initializers) {
                initializer.onStartup(context.getServletContext());
            }
        }
        finally {
            context.getContext().setExtendedListenerTypes(false);
        }
    }
}

