/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.test.mock.mockito.Definition;
import org.springframework.boot.test.mock.mockito.DefinitionsParser;
import org.springframework.boot.test.mock.mockito.MockDefinition;
import org.springframework.boot.test.mock.mockito.MockitoBeans;
import org.springframework.boot.test.mock.mockito.QualifierDefinition;
import org.springframework.boot.test.mock.mockito.SpyDefinition;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.core.Conventions;
import org.springframework.core.Ordered;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class MockitoPostProcessor
implements InstantiationAwareBeanPostProcessor,
BeanClassLoaderAware,
BeanFactoryAware,
BeanFactoryPostProcessor,
Ordered {
    private static final String BEAN_NAME = MockitoPostProcessor.class.getName();
    private static final String CONFIGURATION_CLASS_ATTRIBUTE = Conventions.getQualifiedAttributeName(ConfigurationClassPostProcessor.class, "configurationClass");
    private static final BeanNameGenerator beanNameGenerator = new DefaultBeanNameGenerator();
    private final Set<Definition> definitions;
    private ClassLoader classLoader;
    private BeanFactory beanFactory;
    private final MockitoBeans mockitoBeans = new MockitoBeans();
    private final Map<Definition, String> beanNameRegistry = new HashMap<Definition, String>();
    private final Map<Field, String> fieldRegistry = new HashMap<Field, String>();
    private final Map<String, SpyDefinition> spies = new HashMap<String, SpyDefinition>();

    public MockitoPostProcessor(Set<Definition> definitions) {
        this.definitions = definitions;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, "Mock beans can only be used with a ConfigurableListableBeanFactory");
        this.beanFactory = beanFactory;
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(BeanDefinitionRegistry.class, (Object)beanFactory, "@MockBean can only be used on bean factories that implement BeanDefinitionRegistry");
        this.postProcessBeanFactory(beanFactory, (BeanDefinitionRegistry)((Object)beanFactory));
    }

    private void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry) {
        beanFactory.registerSingleton(MockitoBeans.class.getName(), this.mockitoBeans);
        DefinitionsParser parser = new DefinitionsParser(this.definitions);
        for (Class<?> configurationClass : this.getConfigurationClasses(beanFactory)) {
            parser.parse(configurationClass);
        }
        Set<Definition> definitions = parser.getDefinitions();
        for (Definition definition : definitions) {
            Field field = parser.getField(definition);
            this.register(beanFactory, registry, definition, field);
        }
    }

    private Set<Class<?>> getConfigurationClasses(ConfigurableListableBeanFactory beanFactory) {
        LinkedHashSet configurationClasses = new LinkedHashSet();
        for (BeanDefinition beanDefinition : this.getConfigurationBeanDefinitions(beanFactory).values()) {
            configurationClasses.add(ClassUtils.resolveClassName(beanDefinition.getBeanClassName(), this.classLoader));
        }
        return configurationClasses;
    }

    private Map<String, BeanDefinition> getConfigurationBeanDefinitions(ConfigurableListableBeanFactory beanFactory) {
        LinkedHashMap<String, BeanDefinition> definitions = new LinkedHashMap<String, BeanDefinition>();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
            if (definition.getAttribute(CONFIGURATION_CLASS_ATTRIBUTE) == null) continue;
            definitions.put(beanName, definition);
        }
        return definitions;
    }

    private void register(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, Definition definition, Field field) {
        if (definition instanceof MockDefinition) {
            MockDefinition mockDefinition = (MockDefinition)definition;
            this.registerMock(beanFactory, registry, mockDefinition, field);
        } else if (definition instanceof SpyDefinition) {
            SpyDefinition spyDefinition = (SpyDefinition)definition;
            this.registerSpy(beanFactory, registry, spyDefinition, field);
        }
    }

    private void registerMock(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, MockDefinition definition, Field field) {
        RootBeanDefinition beanDefinition = this.createBeanDefinition(definition);
        String beanName = this.getBeanName(beanFactory, registry, definition, beanDefinition);
        String transformedBeanName = BeanFactoryUtils.transformedBeanName(beanName);
        if (registry.containsBeanDefinition(transformedBeanName)) {
            BeanDefinition existing = registry.getBeanDefinition(transformedBeanName);
            this.copyBeanDefinitionDetails(existing, beanDefinition);
            registry.removeBeanDefinition(transformedBeanName);
        }
        registry.registerBeanDefinition(transformedBeanName, beanDefinition);
        Object mock = definition.createMock(beanName + " bean");
        beanFactory.registerSingleton(transformedBeanName, mock);
        this.mockitoBeans.add(mock);
        this.beanNameRegistry.put(definition, beanName);
        if (field != null) {
            this.fieldRegistry.put(field, beanName);
        }
    }

    private RootBeanDefinition createBeanDefinition(MockDefinition mockDefinition) {
        RootBeanDefinition definition = new RootBeanDefinition(mockDefinition.getTypeToMock().resolve());
        definition.setTargetType(mockDefinition.getTypeToMock());
        if (mockDefinition.getQualifier() != null) {
            mockDefinition.getQualifier().applyTo(definition);
        }
        return definition;
    }

    private String getBeanName(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, MockDefinition mockDefinition, RootBeanDefinition beanDefinition) {
        if (StringUtils.hasLength(mockDefinition.getName())) {
            return mockDefinition.getName();
        }
        Set<String> existingBeans = this.getExistingBeans(beanFactory, mockDefinition.getTypeToMock(), mockDefinition.getQualifier());
        if (existingBeans.isEmpty()) {
            return beanNameGenerator.generateBeanName(beanDefinition, registry);
        }
        if (existingBeans.size() == 1) {
            return existingBeans.iterator().next();
        }
        String primaryCandidate = this.determinePrimaryCandidate(registry, existingBeans, mockDefinition.getTypeToMock());
        if (primaryCandidate != null) {
            return primaryCandidate;
        }
        throw new IllegalStateException("Unable to register mock bean " + mockDefinition.getTypeToMock() + " expected a single matching bean to replace but found " + existingBeans);
    }

    private void copyBeanDefinitionDetails(BeanDefinition from, RootBeanDefinition to) {
        to.setPrimary(from.isPrimary());
    }

    private void registerSpy(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, SpyDefinition spyDefinition, Field field) {
        Set<String> existingBeans = this.getExistingBeans(beanFactory, spyDefinition.getTypeToSpy(), spyDefinition.getQualifier());
        if (ObjectUtils.isEmpty(existingBeans)) {
            this.createSpy(registry, spyDefinition, field);
        } else {
            this.registerSpies(registry, spyDefinition, field, existingBeans);
        }
    }

    private Set<String> getExistingBeans(ConfigurableListableBeanFactory beanFactory, ResolvableType type, QualifierDefinition qualifier) {
        TreeSet<String> candidates = new TreeSet<String>();
        for (String candidate : this.getExistingBeans(beanFactory, type)) {
            if (qualifier != null && !qualifier.matches(beanFactory, candidate)) continue;
            candidates.add(candidate);
        }
        return candidates;
    }

    private Set<String> getExistingBeans(ConfigurableListableBeanFactory beanFactory, ResolvableType resolvableType) {
        LinkedHashSet<String> beans2 = new LinkedHashSet<String>(Arrays.asList(beanFactory.getBeanNamesForType(resolvableType, true, false)));
        Class<?> type = resolvableType.resolve(Object.class);
        for (String beanName : beanFactory.getBeanNamesForType(FactoryBean.class, true, false)) {
            Class<?> producedType = beanFactory.getType(beanName = BeanFactoryUtils.transformedBeanName(beanName), false);
            if (!type.equals(producedType)) continue;
            beans2.add(beanName);
        }
        beans2.removeIf(this::isScopedTarget);
        return beans2;
    }

    private boolean isScopedTarget(String beanName) {
        try {
            return ScopedProxyUtils.isScopedTarget(beanName);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private void createSpy(BeanDefinitionRegistry registry, SpyDefinition spyDefinition, Field field) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(spyDefinition.getTypeToSpy().resolve());
        String beanName = beanNameGenerator.generateBeanName(beanDefinition, registry);
        registry.registerBeanDefinition(beanName, beanDefinition);
        this.registerSpy(spyDefinition, field, beanName);
    }

    private void registerSpies(BeanDefinitionRegistry registry, SpyDefinition spyDefinition, Field field, Collection<String> existingBeans) {
        try {
            String beanName = this.determineBeanName(existingBeans, spyDefinition, registry);
            this.registerSpy(spyDefinition, field, beanName);
        }
        catch (RuntimeException ex) {
            throw new IllegalStateException("Unable to register spy bean " + spyDefinition.getTypeToSpy(), ex);
        }
    }

    private String determineBeanName(Collection<String> existingBeans, SpyDefinition definition, BeanDefinitionRegistry registry) {
        if (StringUtils.hasText(definition.getName())) {
            return definition.getName();
        }
        if (existingBeans.size() == 1) {
            return existingBeans.iterator().next();
        }
        return this.determinePrimaryCandidate(registry, existingBeans, definition.getTypeToSpy());
    }

    private String determinePrimaryCandidate(BeanDefinitionRegistry registry, Collection<String> candidateBeanNames, ResolvableType type) {
        String primaryBeanName = null;
        for (String candidateBeanName : candidateBeanNames) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(candidateBeanName);
            if (!beanDefinition.isPrimary()) continue;
            if (primaryBeanName != null) {
                throw new NoUniqueBeanDefinitionException(type.resolve(), candidateBeanNames.size(), "more than one 'primary' bean found among candidates: " + Collections.singletonList(candidateBeanNames));
            }
            primaryBeanName = candidateBeanName;
        }
        return primaryBeanName;
    }

    private void registerSpy(SpyDefinition definition, Field field, String beanName) {
        this.spies.put(beanName, definition);
        this.beanNameRegistry.put(definition, beanName);
        if (field != null) {
            this.fieldRegistry.put(field, beanName);
        }
    }

    protected final Object createSpyIfNecessary(Object bean2, String beanName) throws BeansException {
        SpyDefinition definition = this.spies.get(beanName);
        if (definition != null) {
            bean2 = definition.createSpy(beanName, bean2);
        }
        return bean2;
    }

    @Override
    public PropertyValues postProcessProperties(PropertyValues pvs, Object bean2, String beanName) throws BeansException {
        ReflectionUtils.doWithFields(bean2.getClass(), field -> this.postProcessField(bean2, field));
        return pvs;
    }

    private void postProcessField(Object bean2, Field field) {
        String beanName = this.fieldRegistry.get(field);
        if (StringUtils.hasText(beanName)) {
            this.inject(field, bean2, beanName);
        }
    }

    void inject(Field field, Object target, Definition definition) {
        String beanName = this.beanNameRegistry.get(definition);
        Assert.state(StringUtils.hasLength(beanName), () -> "No bean found for definition " + definition);
        this.inject(field, target, beanName);
    }

    private void inject(Field field, Object target, String beanName) {
        try {
            field.setAccessible(true);
            Object existingValue = ReflectionUtils.getField(field, target);
            Object bean2 = this.beanFactory.getBean(beanName, field.getType());
            if (existingValue == bean2) {
                return;
            }
            Assert.state(existingValue == null, () -> "The existing value '" + existingValue + "' of field '" + field + "' is not the same as the new value '" + bean2 + "'");
            ReflectionUtils.setField(field, target, bean2);
        }
        catch (Throwable ex) {
            throw new BeanCreationException("Could not inject field: " + field, ex);
        }
    }

    @Override
    public int getOrder() {
        return 0x7FFFFFF5;
    }

    public static void register(BeanDefinitionRegistry registry) {
        MockitoPostProcessor.register(registry, null);
    }

    public static void register(BeanDefinitionRegistry registry, Set<Definition> definitions) {
        MockitoPostProcessor.register(registry, MockitoPostProcessor.class, definitions);
    }

    public static void register(BeanDefinitionRegistry registry, Class<? extends MockitoPostProcessor> postProcessor, Set<Definition> definitions) {
        SpyPostProcessor.register(registry);
        BeanDefinition definition = MockitoPostProcessor.getOrAddBeanDefinition(registry, postProcessor);
        ConstructorArgumentValues.ValueHolder constructorArg = definition.getConstructorArgumentValues().getIndexedArgumentValue(0, Set.class);
        Set existing = (Set)constructorArg.getValue();
        if (definitions != null) {
            existing.addAll(definitions);
        }
    }

    private static BeanDefinition getOrAddBeanDefinition(BeanDefinitionRegistry registry, Class<? extends MockitoPostProcessor> postProcessor) {
        if (!registry.containsBeanDefinition(BEAN_NAME)) {
            RootBeanDefinition definition = new RootBeanDefinition(postProcessor);
            definition.setRole(2);
            ConstructorArgumentValues constructorArguments = definition.getConstructorArgumentValues();
            constructorArguments.addIndexedArgumentValue(0, new LinkedHashSet());
            registry.registerBeanDefinition(BEAN_NAME, definition);
            return definition;
        }
        return registry.getBeanDefinition(BEAN_NAME);
    }

    static class SpyPostProcessor
    implements SmartInstantiationAwareBeanPostProcessor,
    PriorityOrdered {
        private static final String BEAN_NAME = SpyPostProcessor.class.getName();
        private final Map<String, Object> earlySpyReferences = new ConcurrentHashMap<String, Object>(16);
        private final MockitoPostProcessor mockitoPostProcessor;

        SpyPostProcessor(MockitoPostProcessor mockitoPostProcessor) {
            this.mockitoPostProcessor = mockitoPostProcessor;
        }

        @Override
        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        @Override
        public Object getEarlyBeanReference(Object bean2, String beanName) throws BeansException {
            if (bean2 instanceof FactoryBean) {
                return bean2;
            }
            this.earlySpyReferences.put(this.getCacheKey(bean2, beanName), bean2);
            return this.mockitoPostProcessor.createSpyIfNecessary(bean2, beanName);
        }

        @Override
        public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
            if (bean2 instanceof FactoryBean) {
                return bean2;
            }
            if (this.earlySpyReferences.remove(this.getCacheKey(bean2, beanName)) != bean2) {
                return this.mockitoPostProcessor.createSpyIfNecessary(bean2, beanName);
            }
            return bean2;
        }

        private String getCacheKey(Object bean2, String beanName) {
            return StringUtils.hasLength(beanName) ? beanName : bean2.getClass().getName();
        }

        static void register(BeanDefinitionRegistry registry) {
            if (!registry.containsBeanDefinition(BEAN_NAME)) {
                RootBeanDefinition definition = new RootBeanDefinition(SpyPostProcessor.class);
                definition.setRole(2);
                ConstructorArgumentValues constructorArguments = definition.getConstructorArgumentValues();
                constructorArguments.addIndexedArgumentValue(0, new RuntimeBeanReference(BEAN_NAME));
                registry.registerBeanDefinition(BEAN_NAME, definition);
            }
        }
    }
}

