/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.json;

import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.util.ClassUtils;
import wiremock.com.fasterxml.jackson.databind.ser.std.ClassSerializer;
import wiremock.com.fasterxml.jackson.databind.ser.std.FileSerializer;
import wiremock.com.fasterxml.jackson.databind.ser.std.StdJdkSerializers;
import wiremock.com.fasterxml.jackson.databind.ser.std.TokenBufferSerializer;

class JacksonRuntimeHints
implements RuntimeHintsRegistrar {
    JacksonRuntimeHints() {
    }

    @Override
    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        if (!ClassUtils.isPresent("wiremock.com.fasterxml.jackson.databind.ser.BasicSerializerFactory", classLoader)) {
            return;
        }
        this.registerSerializers(hints.reflection());
    }

    private void registerSerializers(ReflectionHints hints) {
        hints.registerTypes(TypeReference.listOf(StdJdkSerializers.AtomicBooleanSerializer.class, StdJdkSerializers.AtomicIntegerSerializer.class, StdJdkSerializers.AtomicLongSerializer.class, FileSerializer.class, ClassSerializer.class, TokenBufferSerializer.class), TypeHint.builtWith(MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS));
    }
}

