/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FatalStartupException;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.core.Version;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.standalone.CommandLineOptions;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.Set;

public class WireMockServerRunner {
    private static final String BANNER = "\n\u001b[34m\u2588\u2588     \u2588\u2588 \u2588\u2588 \u2588\u2588\u2588\u2588\u2588\u2588  \u2588\u2588\u2588\u2588\u2588\u2588\u2588 \u001b[33m\u2588\u2588\u2588    \u2588\u2588\u2588  \u2588\u2588\u2588\u2588\u2588\u2588   \u2588\u2588\u2588\u2588\u2588\u2588 \u2588\u2588   \u2588\u2588 \n\u001b[34m\u2588\u2588     \u2588\u2588 \u2588\u2588 \u2588\u2588   \u2588\u2588 \u2588\u2588      \u001b[33m\u2588\u2588\u2588\u2588  \u2588\u2588\u2588\u2588 \u2588\u2588    \u2588\u2588 \u2588\u2588      \u2588\u2588  \u2588\u2588  \n\u001b[34m\u2588\u2588  \u2588  \u2588\u2588 \u2588\u2588 \u2588\u2588\u2588\u2588\u2588\u2588  \u2588\u2588\u2588\u2588\u2588   \u001b[33m\u2588\u2588 \u2588\u2588\u2588\u2588 \u2588\u2588 \u2588\u2588    \u2588\u2588 \u2588\u2588      \u2588\u2588\u2588\u2588\u2588   \n\u001b[34m\u2588\u2588 \u2588\u2588\u2588 \u2588\u2588 \u2588\u2588 \u2588\u2588   \u2588\u2588 \u2588\u2588      \u001b[33m\u2588\u2588  \u2588\u2588  \u2588\u2588 \u2588\u2588    \u2588\u2588 \u2588\u2588      \u2588\u2588  \u2588\u2588  \n\u001b[34m \u2588\u2588\u2588 \u2588\u2588\u2588  \u2588\u2588 \u2588\u2588   \u2588\u2588 \u2588\u2588\u2588\u2588\u2588\u2588\u2588 \u001b[33m\u2588\u2588      \u2588\u2588  \u2588\u2588\u2588\u2588\u2588\u2588   \u2588\u2588\u2588\u2588\u2588\u2588 \u2588\u2588   \u2588\u2588 \n\n\u001b[0m----------------------------------------------------------------\n|               Cloud: https://wiremock.io/cloud               |\n|                                                              |\n|               Slack: https://slack.wiremock.org              |\n----------------------------------------------------------------";
    private WireMockServer wireMockServer;

    public void run(String ... args) {
        CommandLineOptions options2 = new CommandLineOptions(args);
        if (options2.help()) {
            System.out.println(options2.helpText());
            return;
        }
        if (options2.version()) {
            System.out.println(Version.getCurrentVersion());
            return;
        }
        FileSource fileSource = options2.filesRoot();
        fileSource.createIfNecessary();
        FileSource filesFileSource = fileSource.child("__files");
        filesFileSource.createIfNecessary();
        FileSource mappingsFileSource = fileSource.child("mappings");
        mappingsFileSource.createIfNecessary();
        this.wireMockServer = new WireMockServer(options2);
        if (options2.recordMappingsEnabled()) {
            this.wireMockServer.enableRecordMappings(mappingsFileSource, filesFileSource);
        }
        if (options2.specifiesProxyUrl()) {
            this.addProxyMapping(options2.proxyUrl());
        }
        try {
            this.wireMockServer.start();
            boolean https = options2.httpsSettings().enabled();
            if (!options2.getHttpDisabled()) {
                options2.setActualHttpPort(this.wireMockServer.port());
            }
            if (https) {
                options2.setActualHttpsPort(this.wireMockServer.httpsPort());
            }
            if (!options2.bannerDisabled()) {
                System.out.println(BANNER);
                System.out.println();
            } else {
                System.out.println();
                System.out.println("The WireMock server is started .....");
            }
            System.out.println(options2);
            Set<String> loadedExtensionNames = this.wireMockServer.getLoadedExtensionNames();
            if (!loadedExtensionNames.isEmpty()) {
                System.out.println("extensions:                   " + String.join((CharSequence)",", loadedExtensionNames));
            }
        }
        catch (FatalStartupException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    private void addProxyMapping(String baseUrl) {
        this.wireMockServer.loadMappingsUsing(stubMappings -> {
            RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern(RequestMethod.ANY, WireMock.anyUrl()).build();
            ResponseDefinition responseDef = ResponseDefinitionBuilder.responseDefinition().proxiedFrom(baseUrl).build();
            StubMapping proxyBasedMapping = new StubMapping(requestPattern, responseDef);
            proxyBasedMapping.setPriority(10);
            stubMappings.addMapping(proxyBasedMapping);
        });
    }

    public void stop() {
        if (this.wireMockServer != null) {
            this.wireMockServer.stop();
        }
    }

    public boolean isRunning() {
        if (this.wireMockServer == null) {
            return false;
        }
        return this.wireMockServer.isRunning();
    }

    public int port() {
        return this.wireMockServer.port();
    }
}

