/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.security;

import com.github.tomakehurst.wiremock.client.BasicCredentials;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.security.Authenticator;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class BasicAuthenticator
implements Authenticator {
    private final List<BasicCredentials> credentials;

    public BasicAuthenticator(List<BasicCredentials> credentials) {
        this.credentials = credentials;
    }

    public BasicAuthenticator(BasicCredentials ... credentials) {
        this.credentials = Arrays.asList(credentials);
    }

    public BasicAuthenticator(String username, String password) {
        this(new BasicCredentials(username, password));
    }

    @Override
    public boolean authenticate(Request request2) {
        List headerValues = this.credentials.stream().map(BasicCredentials::asAuthorizationHeaderValue).collect(Collectors.toList());
        return request2.containsHeader("Authorization") && headerValues.contains(request2.header("Authorization").firstValue());
    }
}

