/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty11;

import java.io.IOException;
import wiremock.jakarta.servlet.ServletException;
import wiremock.jakarta.servlet.http.HttpServletRequest;
import wiremock.jakarta.servlet.http.HttpServletResponse;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.ServerConnector;
import wiremock.org.eclipse.jetty.server.handler.AbstractHandler;

public class HttpsProxyDetectingHandler
extends AbstractHandler {
    public static final String IS_HTTPS_PROXY_REQUEST_ATTRIBUTE = "wiremock.isHttpsProxyRequest";
    private final ServerConnector mitmProxyConnector;

    public HttpsProxyDetectingHandler(ServerConnector mitmProxyConnector) {
        this.mitmProxyConnector = mitmProxyConnector;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request2, HttpServletResponse response) throws IOException, ServletException {
        int httpsProxyPort = this.mitmProxyConnector.getLocalPort();
        if (request2.getLocalPort() == httpsProxyPort) {
            request2.setAttribute(IS_HTTPS_PROXY_REQUEST_ATTRIBUTE, true);
        }
    }
}

