/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.multipart;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.multipart.FileItemPartAdapter;
import com.github.tomakehurst.wiremock.http.multipart.FileUpload;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import wiremock.org.apache.commons.fileupload.FileItem;
import wiremock.org.apache.commons.fileupload.FileUploadException;
import wiremock.org.apache.commons.fileupload.UploadContext;
import wiremock.org.apache.commons.fileupload.disk.DiskFileItemFactory;

public class PartParser {
    public static Collection<Request.Part> parseFrom(Request request2) {
        DiskFileItemFactory fileItemFactory = new DiskFileItemFactory(Integer.MAX_VALUE, new File(System.getProperty("java.io.tmpdir")));
        HttpHeaders headers = request2.getHeaders();
        ByteArrayUploadContext uploadContext = new ByteArrayUploadContext(request2.getBody(), PartParser.headerValueOrNull("Content-Encoding", headers), headers.getContentTypeHeader().firstValue());
        FileUpload upload = new FileUpload(fileItemFactory);
        try {
            List<FileItem> items = upload.parseRequest(uploadContext);
            return items.stream().map(FileItemPartAdapter.TO_PARTS).collect(Collectors.toList());
        }
        catch (FileUploadException e) {
            return Exceptions.throwUnchecked(e, Collection.class);
        }
    }

    private static String headerValueOrNull(String key, HttpHeaders httpHeaders) {
        HttpHeader header = httpHeaders.getHeader(key);
        return header.isPresent() ? header.firstValue() : null;
    }

    public static class ByteArrayUploadContext
    implements UploadContext {
        private final byte[] content;
        private final String encoding;
        private final String contentType;

        public ByteArrayUploadContext(byte[] content, String encoding, String contentType) {
            this.content = content;
            this.encoding = encoding;
            this.contentType = contentType;
        }

        @Override
        public long contentLength() {
            return this.content.length;
        }

        @Override
        public String getCharacterEncoding() {
            return this.encoding;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public int getContentLength() {
            return this.content.length;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.content);
        }
    }
}

