/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import wiremock.com.github.jknack.handlebars.Options;
import wiremock.com.github.jknack.handlebars.TagType;

public class JoinHelper
extends HandlebarsHelper<Object> {
    @Override
    public Object apply(Object context, Options options2) throws IOException {
        if (!(context instanceof String)) {
            return this.handleError("Separator parameter must be a String");
        }
        String separator = (String)context;
        Object firstParam = options2.param(0, null);
        if (firstParam == null) {
            return this.handleError("The parameter must be list");
        }
        List<Object> items = Iterable.class.isAssignableFrom(firstParam.getClass()) ? (List<Object>)firstParam : Arrays.asList(options2.params);
        String prefix = (String)options2.hash("prefix", "");
        String suffix = (String)options2.hash("suffix", "");
        if (items.isEmpty()) {
            return "";
        }
        String result = options2.tagType == TagType.SECTION ? JoinHelper.processSection(options2, separator, items) : JoinHelper.processWithoutSection(separator, items);
        return prefix + result + suffix;
    }

    private static String processWithoutSection(String separator, List<Object> items) {
        StringBuilder sb = new StringBuilder();
        boolean initialised = false;
        for (Object item : items) {
            if (initialised) {
                sb.append(separator);
            }
            sb.append(item.toString());
            initialised = true;
        }
        return sb.toString();
    }

    private static String processSection(Options options2, String separator, List<Object> list) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            CharSequence itemRendered = options2.fn(list.get(i2));
            sb.append(itemRendered);
            if (i2 >= list.size() - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }
}

