/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.distribution.validation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jboss.metadata.parser.util.XMLResourceResolver;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AbstractValidationUnitTest {
    private static final String SCHEMAS_LOCATION = "docs/schema";
    private static final String JBOSS_DIST_PROP_NAME = "jboss.dist";
    private static final String FUTURE_SCHEMA_PROP_NAME = "jboss.test.xml.validation.future.schemas";
    private static final Set<String> EXCLUDED_SCHEMA_FILES;
    private static final Set<String> FUTURE_SCHEMA_FILES;
    private static final Map<String, File> JBOSS_SCHEMAS_MAP;
    private static final Map<String, File> CURRENT_JBOSS_SCHEMAS_MAP;
    private static final Source[] SCHEMA_SOURCES;
    private static final Map<String, String> NAMESPACE_MAP;
    private static final Map<String, String> OUTDATED_NAMESPACES;
    private static final File JBOSS_DIST_DIR;
    static final LSResourceResolver DEFAULT_RESOURCE_RESOLVER;

    protected static File getBaseDir() {
        Assert.assertNotNull((String)"'jboss.dist' is not set.", (Object)JBOSS_DIST_DIR);
        Assert.assertTrue((String)("Directory set in 'jboss.dist' does not exist: " + JBOSS_DIST_DIR.getAbsolutePath()), (boolean)JBOSS_DIST_DIR.exists());
        return JBOSS_DIST_DIR;
    }

    static URL discoverXsd(String xsdName) {
        if (OUTDATED_NAMESPACES.containsKey(xsdName)) {
            throw new RuntimeException("Default configs are not in line with most recent schemas " + xsdName + " has been superseded by " + OUTDATED_NAMESPACES.get(xsdName));
        }
        File file = JBOSS_SCHEMAS_MAP.get(xsdName);
        URL url = null;
        try {
            if (file != null) {
                url = file.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        if (url == null && xsdName != null) {
            File schemaDir;
            File schema;
            ClassLoader classLoader;
            String fileName = xsdName;
            int index = fileName.lastIndexOf("/");
            if (index == -1) {
                index = fileName.lastIndexOf("\\");
            }
            if (index != -1) {
                fileName = fileName.substring(index + 1);
            }
            if ((url = (classLoader = Thread.currentThread().getContextClassLoader()).getResource("docs/schema/" + fileName)) == null) {
                url = classLoader.getResource("docs/" + fileName);
            }
            if (url == null) {
                url = classLoader.getResource("schema/" + fileName);
            }
            if (url == null) {
                url = classLoader.getResource(fileName);
            }
            if (url == null && (schema = new File(schemaDir = new File(JBOSS_DIST_DIR, SCHEMAS_LOCATION), fileName)).exists()) {
                try {
                    url = schema.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        Assert.assertNotNull((String)(xsdName + " not found"), (Object)url);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void jbossXsdsTest() throws Exception {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try (URLClassLoader cl = AbstractValidationUnitTest.initClassLoader();){
            Thread.currentThread().setContextClassLoader(cl);
            for (File xsdFile : JBOSS_SCHEMAS_MAP.values()) {
                AbstractValidationUnitTest.validateXsd(xsdFile);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    private static void validateXsd(File xsdFile) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.parse(xsdFile);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setErrorHandler(new ErrorHandlerImpl());
        schemaFactory.setResourceResolver((LSResourceResolver)new XMLResourceResolver());
        Schema schema = schemaFactory.newSchema(AbstractValidationUnitTest.getXMLSchemaResource());
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(document));
    }

    private static URL getXMLSchemaResource() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL resource = classLoader.getResource("schema/XMLSchema.xsd");
        Assert.assertNotNull((String)("Can't locate resource schema/XMLSchema.xsd on " + classLoader), (Object)resource);
        return resource;
    }

    private static URLClassLoader initClassLoader() throws IOException {
        String path = System.getProperty("jboss.actual.dist");
        Path modules = Paths.get(path, "modules/system/layers/base");
        final ArrayList urls = new ArrayList();
        Files.walkFileTree(modules, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toString().endsWith(".jar")) {
                    urls.add(file.toFile().toURI().toURL());
                }
                return FileVisitResult.CONTINUE;
            }
        });
        URL[] arr = new URL[urls.size()];
        urls.toArray(arr);
        return new URLClassLoader(arr);
    }

    protected void parseXml(String xmlName) throws SAXException, IOException {
        File xmlFile = this.getXmlFile(xmlName);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setErrorHandler(new ErrorHandlerImpl(xmlFile.toPath()));
        schemaFactory.setResourceResolver(DEFAULT_RESOURCE_RESOLVER);
        Schema schema = schemaFactory.newSchema(SCHEMA_SOURCES);
        Validator validator = schema.newValidator();
        validator.setErrorHandler(new ErrorHandlerImpl(xmlFile.toPath()));
        validator.setFeature("http://apache.org/xml/features/validation/schema", true);
        validator.setResourceResolver(DEFAULT_RESOURCE_RESOLVER);
        validator.validate(new StreamSource(xmlFile));
        xmlFile.delete();
    }

    private File getXmlFile(String xmlName) throws IOException {
        File tmp = File.createTempFile(this.getClass().getSimpleName(), "xml");
        tmp.deleteOnExit();
        File target = new File(AbstractValidationUnitTest.getBaseDir(), xmlName);
        try (BufferedWriter writer = Files.newBufferedWriter(tmp.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            List<String> lines = Files.readAllLines(target.toPath(), StandardCharsets.UTF_8);
            for (String line : lines) {
                writer.write(AbstractValidationUnitTest.fixExpressions(line));
                writer.newLine();
            }
        }
        return tmp;
    }

    private static String fixExpressions(String line) {
        String result = line.replace("${jboss.management.native.port:9999}", "9999");
        result = result.replace("${jboss.management.http.port:9990}", "9990");
        result = result.replace("${jboss.management.https.port:9993}", "9993");
        result = result.replace("${jboss.domain.primary.protocol:remote}", "remote");
        result = result.replace("${jboss.domain.primary.protocol:remote+http}", "remote+http");
        result = result.replace("${jboss.domain.primary.port:9999}", "9999");
        result = result.replace("${jboss.domain.primary.port:9990}", "9990");
        result = result.replace("${jboss.mail.server.host:localhost}", "localhost");
        result = result.replace("${jboss.mail.server.port:25}", "25");
        result = result.replace("${jboss.messaging.group.port:9876}", "9876");
        result = result.replace("${jboss.socket.binding.port-offset:0}", "0");
        result = result.replace("${jboss.http.port:8080}", "8080");
        result = result.replace("${jboss.https.port:8443}", "8443");
        result = result.replace("${jboss.remoting.port:4447}", "4447");
        result = result.replace("${jboss.ajp.port:8009}", "8009");
        result = result.replace("${jboss.mcmp.port:8090}", "8090");
        result = result.replace("${jboss.deployment.scanner.rollback.on.failure:false}", "false");
        result = result.replace("${wildfly.datasources.statistics-enabled:${wildfly.statistics-enabled:false}}", "false");
        result = result.replace("${wildfly.ejb.statistics-enabled:${wildfly.statistics-enabled:false}}", "false");
        result = result.replace("${wildfly.messaging-activemq.statistics-enabled:${wildfly.statistics-enabled:false}}", "false");
        result = result.replace("${wildfly.transactions.statistics-enabled:${wildfly.statistics-enabled:false}}", "false");
        result = result.replace("${wildfly.undertow.statistics-enabled:${wildfly.statistics-enabled:false}}", "false");
        result = result.replace("${wildfly.webservices.statistics-enabled:${wildfly.statistics-enabled:false}}", "false");
        result = result.replace("${env.MP_HEALTH_EMPTY_LIVENESS_CHECKS_STATUS:UP}", "UP");
        result = result.replace("${env.MP_HEALTH_EMPTY_READINESS_CHECKS_STATUS:UP}", "UP");
        result = result.replace("${env.MP_HEALTH_EMPTY_STARTUP_CHECKS_STATUS:UP}", "UP");
        result = result.replace("${jboss.messaging.connector.host:localhost}", "localhost");
        result = result.replace("${jboss.messaging.connector.port:61616}", "61616");
        return result;
    }

    static {
        String excluded;
        EXCLUDED_SCHEMA_FILES = new HashSet<String>();
        FUTURE_SCHEMA_FILES = new HashSet<String>();
        JBOSS_SCHEMAS_MAP = new HashMap<String, File>();
        CURRENT_JBOSS_SCHEMAS_MAP = new HashMap<String, File>();
        NAMESPACE_MAP = new HashMap<String, String>();
        OUTDATED_NAMESPACES = new HashMap<String, String>();
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb3-2_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb3-2_1.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb3-spec-2_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb3-spec-2_1.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb3-spec-4_01.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-cache_1_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-cache_2_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-container-interceptors_1_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-container-interceptors_2_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-delivery-active_1_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-delivery-active_1_1.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-delivery-active_1_2.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-delivery-active_2_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-clustering_1_1.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-clustering_2_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-iiop_1_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-iiop_1_1.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-iiop_1_2.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-iiop_2_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-pool_1_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-pool_2_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-resource-adapter-binding_1_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-resource-adapter-binding_2_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-security_1_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-security_1_1.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-security_2_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-security-role_1_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-security-role_2_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-timer-service_2_0.xsd");
        EXCLUDED_SCHEMA_FILES.add("jboss-ejb-timer-service_3_0.xsd");
        String coreVersion = System.getProperty("version.org.wildfly.core");
        if (coreVersion != null && (excluded = System.getProperty(FUTURE_SCHEMA_PROP_NAME)) != null) {
            excluded = excluded.trim();
            String[] pairs = excluded.split(",");
            for (String pair : pairs) {
                String[] tuple;
                if (pair.length() <= 0 || (tuple = pair.split("/")).length != 2 || !coreVersion.equals(tuple[0])) continue;
                FUTURE_SCHEMA_FILES.add(tuple[1]);
            }
        }
        NAMESPACE_MAP.put("http://java.sun.com/xml/ns/javaee/javaee_6.xsd", "schema/javaee_6.xsd");
        NAMESPACE_MAP.put("http://www.w3.org/2001/xml.xsd", "schema/xml.xsd");
        NAMESPACE_MAP.put("http://java.sun.com/xml/ns/javaee/ejb-jar_3_1.xsd", "schema/ejb-jar_3_1.xsd");
        NAMESPACE_MAP.put("http://www.jboss.org/j2ee/schema/jboss-common_7_0.xsd", "jboss-common_7_0.xsd");
        String asDir = System.getProperty(JBOSS_DIST_PROP_NAME);
        if (null == asDir) {
            JBOSS_DIST_DIR = null;
        } else {
            String name;
            Matcher match;
            File[] xsds;
            JBOSS_DIST_DIR = new File(asDir);
            if (!JBOSS_DIST_DIR.exists()) {
                throw new IllegalStateException("Directory set in 'jboss.dist' does not exist: " + JBOSS_DIST_DIR.getAbsolutePath());
            }
            File schemaDir = new File(JBOSS_DIST_DIR, SCHEMAS_LOCATION);
            for (File xsd : xsds = schemaDir.listFiles(new SchemaFilter(EXCLUDED_SCHEMA_FILES.toArray(new String[0])))) {
                JBOSS_SCHEMAS_MAP.put(xsd.getName(), xsd);
            }
            HashMap<String, BigDecimal> mostRecentVersions = new HashMap<String, BigDecimal>();
            HashMap<String, String> mostRecentNames = new HashMap<String, String>();
            Pattern pattern = Pattern.compile("(.*?)_(\\d+)_(\\d+).xsd");
            for (Map.Entry<String, File> entry : JBOSS_SCHEMAS_MAP.entrySet()) {
                if (FUTURE_SCHEMA_FILES.contains(entry.getKey()) || !(match = pattern.matcher(entry.getKey())).matches()) continue;
                name = match.group(1);
                String major = match.group(2);
                String minor = match.group(3);
                BigDecimal version = new BigDecimal(major + "." + minor);
                BigDecimal current = (BigDecimal)mostRecentVersions.get(name);
                if (current != null && version.compareTo(current) <= 0) continue;
                mostRecentVersions.put(name, version);
                mostRecentNames.put(name, entry.getKey());
            }
            for (Map.Entry<String, File> entry : JBOSS_SCHEMAS_MAP.entrySet()) {
                if (FUTURE_SCHEMA_FILES.contains(entry.getKey()) || !(match = pattern.matcher(entry.getKey())).matches()) continue;
                name = match.group(1);
                if (!((String)mostRecentNames.get(name)).equals(entry.getKey())) {
                    OUTDATED_NAMESPACES.put(entry.getKey(), (String)mostRecentNames.get(name));
                    continue;
                }
                CURRENT_JBOSS_SCHEMAS_MAP.put(entry.getKey(), entry.getValue());
            }
        }
        LinkedList<StreamSource> sources = new LinkedList<StreamSource>();
        for (File file : CURRENT_JBOSS_SCHEMAS_MAP.values()) {
            sources.add(new StreamSource(file));
        }
        SCHEMA_SOURCES = sources.toArray(new Source[0]);
        DEFAULT_RESOURCE_RESOLVER = new LSResourceResolver(){

            @Override
            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                DOMImplementationLS impl;
                try {
                    impl = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("could not create LS input", e);
                }
                LSInput input = impl.createLSInput();
                URL url = NAMESPACE_MAP.containsKey(systemId) ? AbstractValidationUnitTest.discoverXsd(NAMESPACE_MAP.get(systemId)) : AbstractValidationUnitTest.discoverXsd(systemId);
                try {
                    input.setByteStream(url.openStream());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return input;
            }
        };
    }

    protected static final class ErrorHandlerImpl
    implements ErrorHandler {
        private final Path file;

        ErrorHandlerImpl() {
            this(null);
        }

        ErrorHandlerImpl(Path file) {
            this.file = file;
        }

        @Override
        public void error(SAXParseException e) {
            Assert.fail((String)this.formatMessage(e));
        }

        @Override
        public void fatalError(SAXParseException e) {
            Assert.fail((String)this.formatMessage(e));
        }

        @Override
        public void warning(SAXParseException e) {
            System.out.println(this.formatMessage(e));
        }

        private String formatMessage(SAXParseException e) {
            StringBuilder sb = new StringBuilder();
            sb.append(e.getLineNumber()).append(':').append(e.getColumnNumber());
            if (e.getPublicId() != null) {
                sb.append(" publicId='").append(e.getPublicId()).append('\'');
            }
            if (e.getSystemId() != null) {
                sb.append(" systemId='").append(e.getSystemId()).append('\'');
            }
            sb.append(' ').append(e.getLocalizedMessage());
            sb.append(" a possible cause may be that a subsystem is not using the most up to date schema.");
            if (this.file != null) {
                try {
                    List<String> lines = Files.readAllLines(this.file);
                    int i = e.getLineNumber() - 1;
                    sb.append(System.lineSeparator());
                    sb.append("Possible line: ").append(lines.get(i));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return sb.toString();
        }
    }

    private static class SchemaFilter
    implements FilenameFilter {
        private static final Pattern PATTERN = Pattern.compile("(jboss|wildfly)-.*\\.xsd$");
        private final String[] exclusions;

        SchemaFilter(String[] exclusions) {
            this.exclusions = exclusions;
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean accepted = PATTERN.matcher(name).find();
            if (accepted) {
                for (String excludedFile : this.exclusions) {
                    if (!excludedFile.equals(name)) continue;
                    return false;
                }
            }
            return accepted;
        }
    }
}

