/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.logging.syslogserver;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.SocketException;
import java.util.List;
import org.jboss.as.test.integration.logging.syslogserver.Rfc5424SyslogEvent;
import org.jboss.logging.Logger;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.server.SyslogServerEventHandlerIF;
import org.productivity.java.syslog4j.server.SyslogServerEventIF;
import org.productivity.java.syslog4j.server.SyslogServerIF;
import org.productivity.java.syslog4j.server.impl.net.udp.UDPNetSyslogServer;

public class UDPSyslogServer
extends UDPNetSyslogServer {
    private static Logger LOGGER = Logger.getLogger(UDPSyslogServer.class);

    public void shutdown() {
        super.shutdown();
        this.thread = null;
    }

    public void run() {
        this.shutdown = false;
        try {
            this.ds = this.createDatagramSocket();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Creating DatagramSocket failed", (Throwable)e);
            throw new SyslogRuntimeException((Throwable)e);
        }
        byte[] receiveData = new byte[1024];
        while (!this.shutdown) {
            try {
                DatagramPacket dp = new DatagramPacket(receiveData, receiveData.length);
                this.ds.receive(dp);
                Rfc5424SyslogEvent event = new Rfc5424SyslogEvent(receiveData, dp.getOffset(), dp.getLength());
                List list = this.syslogServerConfig.getEventHandlers();
                for (int i = 0; i < list.size(); ++i) {
                    SyslogServerEventHandlerIF eventHandler = (SyslogServerEventHandlerIF)list.get(i);
                    eventHandler.event((SyslogServerIF)this, (SyslogServerEventIF)event);
                }
            }
            catch (SocketException se) {
                LOGGER.warn((Object)"SocketException occurred", (Throwable)se);
            }
            catch (IOException ioe) {
                LOGGER.warn((Object)"IOException occurred", (Throwable)ioe);
            }
        }
    }
}

