/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.bridge.impl;

import java.io.IOException;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.model.test.ModelTestOperationValidatorFilter;
import org.jboss.as.subsystem.bridge.local.ClassLoaderObjectConverter;
import org.jboss.as.subsystem.bridge.shared.ObjectSerializer;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.dmr.ModelNode;

public class ClassLoaderObjectConverterImpl
implements ClassLoaderObjectConverter {
    private final ObjectSerializer local;
    private final ObjectSerializer remote;

    public ClassLoaderObjectConverterImpl(ClassLoader local, ClassLoader remote) {
        this.local = ObjectSerializer.FACTORY.createSerializer(local);
        this.remote = ObjectSerializer.FACTORY.createSerializer(remote);
        if (this.local.getClass().getClassLoader() != local) {
            throw new IllegalStateException("Wrong classloader");
        }
        if (this.remote.getClass().getClassLoader() != remote) {
            throw new IllegalStateException("Wrong classloader");
        }
    }

    @Override
    public Object convertModelNodeToChildCl(ModelNode modelNode) {
        if (modelNode == null) {
            return null;
        }
        try {
            return this.remote.deserializeModelNode(this.local.serializeModelNode(modelNode));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ModelNode convertModelNodeFromChildCl(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return (ModelNode)this.local.deserializeModelNode(this.remote.serializeModelNode(object));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object convertModelVersionToChildCl(ModelVersion modelVersion) {
        if (modelVersion == null) {
            return null;
        }
        return this.remote.deserializeModelVersion(this.local.serializeModelVersion(modelVersion));
    }

    @Override
    public Object convertAdditionalInitializationToChildCl(AdditionalInitialization additionalInit) {
        try {
            return this.remote.deserializeAdditionalInitialization(this.local.serializeAdditionalInitialization(additionalInit));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object convertValidateOperationsFilterToChildCl(ModelTestOperationValidatorFilter validateOpsFilter) {
        try {
            return this.remote.deserializeModelTestOperationValidatorFilter(this.local.serializeModelTestOperationValidatorFilter(validateOpsFilter));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

