/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.controller.resources.VaultResourceDefinition;
import org.jboss.as.server.operations.SystemPropertyDeferredProcessor;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.as.server.services.security.VaultReaderException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class VaultAddHandler
extends AbstractAddStepHandler {
    private final AbstractVaultReader vaultReader;

    public VaultAddHandler(AbstractVaultReader vaultReader) {
        this.vaultReader = vaultReader;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : VaultResourceDefinition.ALL_ATTRIBUTES) {
            attr.validateAndSet(operation, model);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String vaultClass;
        ModelNode codeNode = VaultResourceDefinition.CODE.resolveModelAttribute(context, model);
        String string = vaultClass = codeNode.isDefined() ? codeNode.asString() : null;
        if (this.vaultReader != null) {
            HashMap<String, Object> vaultOptions = new HashMap<String, Object>();
            if (operation.hasDefined(VaultResourceDefinition.VAULT_OPTIONS.getName())) {
                for (Map.Entry vaultOption : VaultResourceDefinition.VAULT_OPTIONS.unwrap(context, model).entrySet()) {
                    vaultOptions.put((String)vaultOption.getKey(), vaultOption.getValue());
                }
            }
            try {
                this.vaultReader.createVault(vaultClass, vaultOptions);
            }
            catch (VaultReaderException e) {
                throw ServerMessages.MESSAGES.cannotCreateVault(e, e);
            }
            SystemPropertyDeferredProcessor deferredResolver = (SystemPropertyDeferredProcessor)context.getAttachment(SystemPropertyDeferredProcessor.ATTACHMENT_KEY);
            if (deferredResolver != null) {
                deferredResolver.processDeferredProperties(context);
            }
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        this.vaultReader.destroyVault();
    }
}

