/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.TreeMap;
import org.jboss.as.patching.IoUtils;

public class HashUtils {
    private static final char[] TABLE = "0123456789abcdef".toCharArray();
    private static final MessageDigest DIGEST;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hashFile(File file) throws IOException {
        MessageDigest messageDigest = DIGEST;
        synchronized (messageDigest) {
            DIGEST.reset();
            HashUtils.updateDigest(DIGEST, file);
            return DIGEST.digest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateDigest(MessageDigest digest, File file) throws IOException {
        block8: {
            block7: {
                if (!file.isDirectory()) break block7;
                File[] childList = file.listFiles();
                if (childList == null) break block8;
                TreeMap<String, File> sortedChildren = new TreeMap<String, File>();
                for (File child : childList) {
                    sortedChildren.put(child.getName(), child);
                }
                for (File child : sortedChildren.values()) {
                    HashUtils.updateDigest(digest, child);
                }
                break block8;
            }
            if (file.getName().endsWith(".jar.index")) {
                return;
            }
            FileInputStream fis = new FileInputStream(file);
            try {
                int read;
                BufferedInputStream bis = new BufferedInputStream(fis);
                byte[] bytes = new byte[8192];
                while ((read = bis.read(bytes)) > -1) {
                    digest.update(bytes, 0, read);
                }
            }
            finally {
                IoUtils.safeClose(fis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] copyAndGetHash(InputStream is, OutputStream os) throws IOException {
        byte[] sha1Bytes;
        MessageDigest messageDigest = DIGEST;
        synchronized (messageDigest) {
            DIGEST.reset();
            BufferedInputStream bis = new BufferedInputStream(is);
            DigestOutputStream dos = new DigestOutputStream(os, DIGEST);
            IoUtils.copyStream(bis, dos);
            sha1Bytes = DIGEST.digest();
        }
        return sha1Bytes;
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            builder.append(TABLE[b >> 4 & 0xF]).append(TABLE[b & 0xF]);
        }
        return builder.toString();
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int x = Character.digit(s.charAt(j), 16) << 4;
            x |= Character.digit(s.charAt(++j), 16);
            ++j;
            data[i] = (byte)(x & 0xFF);
            ++i;
        }
        return data;
    }

    static {
        try {
            DIGEST = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

