/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.runner.PatchingTaskContext;

class PatchModuleInvalidationUtils {
    private static final byte INVALIDATION_VALUE = 7;
    private static final byte RESTORE_VALUE = 6;
    private static final byte[] GOOD_SIGNATURE = new byte[]{5, 6};
    private static final byte[] BAD_SIGNATURE = new byte[]{5, 7};

    PatchModuleInvalidationUtils() {
    }

    static void processFile(File file, PatchingTaskContext.Mode mode) throws IOException {
        if (mode == PatchingTaskContext.Mode.APPLY) {
            PatchModuleInvalidationUtils.modifyEndOfCentralDirSig(file, (byte)7, GOOD_SIGNATURE[0], GOOD_SIGNATURE[1]);
        } else if (mode == PatchingTaskContext.Mode.ROLLBACK) {
            PatchModuleInvalidationUtils.modifyEndOfCentralDirSig(file, (byte)6, BAD_SIGNATURE[0], BAD_SIGNATURE[1]);
        } else {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void modifyEndOfCentralDirSig(File file, byte val, int sig1, int sig2) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        try {
            long filePos = raf.length();
            boolean keepSeeking = true;
            int readVal = 0;
            int prevReadVal = 0;
            while (keepSeeking) {
                raf.seek(--filePos);
                prevReadVal = readVal;
                readVal = raf.read();
                if (readVal != sig1 || prevReadVal != sig2) continue;
                raf.write(val);
                keepSeeking = false;
            }
            raf.close();
        }
        finally {
            IoUtils.safeClose(raf);
        }
    }
}

