/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.installation;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.patching.PatchLogger;
import org.jboss.as.patching.installation.AddOn;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.Layer;
import org.jboss.as.patching.installation.MutableTargetImpl;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.metadata.LayerType;

abstract class InstallationModificationImpl
extends MutableTargetImpl
implements InstallationManager.InstallationModification {
    private final String name;
    private final String version;
    private final InstallationState installationState;
    private final AtomicBoolean done = new AtomicBoolean();

    protected InstallationModificationImpl(PatchableTarget.TargetInfo identity, String name, String version, InstallationState installationState) {
        super(identity);
        this.name = name;
        this.version = version;
        this.installationState = installationState;
    }

    @Override
    public InstallationManager.MutablePatchingTarget resolve(String name, LayerType type) {
        if (type == LayerType.Layer) {
            return (InstallationManager.MutablePatchingTarget)this.installationState.layers.get(name);
        }
        return (InstallationManager.MutablePatchingTarget)this.installationState.addOns.get(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    boolean setDone() {
        return this.done.compareAndSet(false, true);
    }

    InstallationState internalComplete() throws Exception {
        if (!this.setDone()) {
            throw new IllegalStateException();
        }
        try {
            this.installationState.persist();
        }
        catch (Exception e) {
            this.installationState.restore();
            throw e;
        }
        try {
            super.persist();
        }
        catch (Exception e) {
            this.installationState.restore();
        }
        return this.installationState;
    }

    static class InstallationState {
        private final Map<String, MutableTargetImpl> layers = new LinkedHashMap<String, MutableTargetImpl>();
        private final Map<String, MutableTargetImpl> addOns = new LinkedHashMap<String, MutableTargetImpl>();

        InstallationState() {
        }

        protected void putLayer(Layer layer) throws IOException {
            this.putPatchableTarget(layer.getName(), layer, this.layers);
        }

        protected void putAddOn(AddOn addOn) throws IOException {
            this.putPatchableTarget(addOn.getName(), addOn, this.addOns);
        }

        protected void putPatchableTarget(String name, PatchableTarget target, Map<String, MutableTargetImpl> map) throws IOException {
            PatchableTarget.TargetInfo info = target.loadTargetInfo();
            map.put(name, new MutableTargetImpl(info));
        }

        Map<String, MutableTargetImpl> getLayers() {
            return this.layers;
        }

        Map<String, MutableTargetImpl> getAddOns() {
            return this.addOns;
        }

        protected void persist() throws IOException {
            for (MutableTargetImpl target : this.layers.values()) {
                target.persist();
            }
            for (MutableTargetImpl target : this.addOns.values()) {
                target.persist();
            }
        }

        private void restore() {
            for (MutableTargetImpl target : this.layers.values()) {
                try {
                    target.restore();
                }
                catch (IOException e) {
                    PatchLogger.ROOT_LOGGER.debugf(e, "failed to restore original state for layer %s", target);
                }
            }
            for (MutableTargetImpl target : this.addOns.values()) {
                try {
                    target.restore();
                }
                catch (IOException e) {
                    PatchLogger.ROOT_LOGGER.debugf(e, "failed to restore original state for add-on %s", target);
                }
            }
        }
    }
}

