/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.jboss.as.patching.generator.PatchConfigBuilder;
import org.jboss.as.patching.generator.PatchElementConfig;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentType;
import org.jboss.as.patching.metadata.ModuleItem;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.runner.ContentItemFilter;

class PatchElementConfigBuilder
implements PatchElementConfig,
ContentItemFilter {
    private final String layerName;
    private final PatchConfigBuilder parent;
    private Patch.PatchType patchType;
    private String patchId = UUID.randomUUID().toString();
    private String description = "no description available";
    private final Set<ContentItem> specifiedContents = new HashSet<ContentItem>();

    PatchElementConfigBuilder(String layerName, PatchConfigBuilder parent) {
        this.layerName = layerName;
        this.parent = parent;
    }

    @Override
    public String getPatchId() {
        return this.patchId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLayerName() {
        return this.layerName;
    }

    @Override
    public Patch.PatchType getPatchType() {
        return this.patchType;
    }

    void setPatchType(Patch.PatchType patchType) {
        this.patchType = patchType;
    }

    void setPatchId(String patchId) {
        this.patchId = patchId;
    }

    void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Set<ContentItem> getSpecifiedContent() {
        return this.specifiedContents;
    }

    @Override
    public boolean accepts(ContentItem item) {
        if (item.getContentType() != ContentType.MISC) {
            for (ContentItem s : this.specifiedContents) {
                if (!PatchElementConfigBuilder.accepts((ModuleItem)s, (ModuleItem)item)) continue;
                return true;
            }
        }
        return this.parent.isGeneratedByDiff();
    }

    static boolean accepts(ModuleItem one, ModuleItem two) {
        return one.getName().equals(two.getName()) && one.getSlot().equals(two.getSlot());
    }
}

